
public class ArbolBinario {
	
	public static void main(String[] args) {
		ArbolBinario ABB = new ArbolBinario(5,
				new ArbolBinario(3,
						new ArbolBinario(2),
						new ArbolBinario(4)),
				new ArbolBinario(7,
						new ArbolBinario(6),
						new ArbolBinario(8,
								null,
								new ArbolBinario(9))));

		ArbolBinario noABB = new ArbolBinario(5,
				new ArbolBinario(3,
						new ArbolBinario(2),
						new ArbolBinario(16)),  // este nodo esta a la izq de 5 y es mayor que el
				new ArbolBinario(8,
						new ArbolBinario(7),
						new ArbolBinario(9)));
		
		System.out.println("el numero de pisos es " + pisos(ABB));  // deberian ser 4
		System.out.println("la suma de todos los nodos es " + suma(noABB));  // deberia ser 50
		System.out.println("el numero de nodos es " + nodos(ABB));  // deberian ser 8
		System.out.println("el maximo es " + max(noABB));  // deberia ser 16
		System.out.println("el minimo es " + min(ABB));  // deberia ser 2
		
		System.out.println("es ABB?");
		System.out.println(ABB(ABB));  // true
		System.out.println(ABB(noABB));  // false

		System.out.println("es ABB? (eficiente)");
		System.out.println(ABBeficiente(ABB));  // true
		System.out.println(ABBeficiente(noABB));  // false
	}
	
	int valor;
	ArbolBinario izq, der;
	
	public ArbolBinario(int valor) {
		this.valor = valor;
		izq = der = null;
	}
	
	public ArbolBinario(int valor, ArbolBinario izq, ArbolBinario der) {
		this.valor = valor;
		this.izq = izq;
		this.der = der;
	}
	
	// para simplificar la recursin sobre el arbol se implementaran mtodos estticos
	
	/**
	 * retorna el numero de nodos.
	 */
	public static int nodos(ArbolBinario arbol) {
		// caso base, un arbol nulo tiene 0 nodos.
		if (arbol == null)
			return 0;
					
		return 1 + nodos(arbol.izq) + nodos(arbol.der);
	}
	
	/**
	 * retorna el maximo valor en el arbol.
	 */
	public static int max(ArbolBinario arbol) {
		// caso base, un arbol nulo no tiene mximo.
		if (arbol == null)
			return Integer.MIN_VALUE;
					
		return Math.max(arbol.valor, Math.max(max(arbol.izq), max(arbol.der)));
	}
	
	/**
	 * retorna el minimo valor en el arbol.
	 */
	public static int min(ArbolBinario arbol) {
		// caso base, un arbol nulo no tiene minimo.
		if (arbol == null)
			return Integer.MAX_VALUE;
					
		return Math.min(arbol.valor, Math.min(min(arbol.izq), min(arbol.der)));
	}
	
	/**
	 * retorna la suma de todos los valores en el arbol.
	 */
	public static int suma(ArbolBinario arbol) {
		// caso base, un arbol nulo suma 0.
		if (arbol == null)
			return 0;
		
		return arbol.valor + suma(arbol.izq) + suma(arbol.der);
	}
	
	/**
	 * retorna el numero de pisos en el arbol.
	 */
	public static int pisos(ArbolBinario arbol) {
		// caso base, un arbol nulo tiene 0 pisos.
		if (arbol == null)
			return 0;
		
		return 1 + Math.max(pisos(arbol.izq), pisos(arbol.der));
	}
	
	/**
	 * detecta si un arbol es ABB.
	 */
	public static boolean ABB(ArbolBinario arbol) {
		// caso base, el arbol nulo si cumple
		if (arbol == null)
			return true;
		
		// comprobar el nodo actual con el maximo y minimo de sus hijos
		if (arbol.valor <= max(arbol.izq) || arbol.valor >= min(arbol.der))
			return false;
		
		return ABB(arbol.der) && ABB(arbol.izq);
	}
	
	/**
	 * detecta si un arbol es ABB de forma eficiente.
	 */
	public static boolean ABBeficiente(ArbolBinario arbol) {
		// llamar al mtodo auxiliar que tiene todos lso argumentos
		return ABBeficiente(arbol, Integer.MIN_VALUE, Integer.MAX_VALUE);
	}
	
	/**
	 * detecta si un arbol es ABB de forma eficiente.
	 * la recursin baja por al arbol solo una vez, la restriccion es que 
	 * los padres del nodo definen cuales son el maximo y minimo valor posible para sus hijos.
	 */
	public static boolean ABBeficiente(ArbolBinario arbol, int min, int max) {
		// caso base, el arbol nulo si cumple
		if (arbol == null)
			return true;
		
		// comprobar el nodo actual con el maximo y minimo de sus padres.
		if  (arbol.valor < min || arbol.valor > max)
			return false;
		
		// llamada recursiva ajustando las restricciones.
		// al bajar hacia la izquierda el maximo cambia al nodo actual,
		// y al bajar hacia la derecha cambia el minimo cabia al nodo actual.
		return ABBeficiente(arbol.izq, min, arbol.valor) &&
				ABBeficiente(arbol.der, arbol.valor, max);
	}
}
