# catalogoCanciones.py
# programa principalcatalogoCanciones.py

L = crearLista(crearCancion("Another Brick in the Wall","Rock",10),\
               crearLista(crearCancion("Bohemian Rhapsody","Rock",20),\
                          crearLista(crearCancion("So What","Jazz",80),\
                                     crearLista(crearCancion("Naima","Jazz",90),\
                                                crearLista(crearCancion("Oye Como Va","Jazz",130),\
                                                           crearLista(crearCancion("Bad Romance","Pop",8),\
                                                                      crearLista(crearCancion("Billie Jean","Pop",284),None)))))))

# 0.6 PUNTOS
# Dada una lista de canciones 'listaCanciones' devuelve otra lista que
# contiene solo las canciones que corresponden a 'genero'
def filtrarPorGenero(genero, listaCanciones):
    assert type(genero) == str
    return filtro(esGenero, listaCanciones, genero)

# 0.6 PUNTOS
# Dada una lista de canciones 'listaCanciones' devuelve su duracion total (int)
def duracionListaCanciones(listaCanciones):
    assert type(listaCanciones)==lista or listaCanciones == None
    return fold(sumaDuracion, 0, listaCanciones)
assert duracionListaCanciones(L)==622

# 0.6 PUNTOS
# Dada una lista de canciones 'listaCanciones' devuelve la duracion de
# la cancion con maxima duracion en seg (int)
def duracionMaximaListaCanciones(listaCanciones):
    assert type(listaCanciones)==lista or listaCanciones == None
    return fold(maxDuracion, 0, listaCanciones)
assert duracionMaximaListaCanciones(L)==284

# 0.6 PUNTOS
# Dada una lista de canciones 'listaCanciones' devuelve la duracion de
# la cancion con minima duracion en seg (int)
def duracionMinimaListaCanciones(listaCanciones):
    assert type(listaCanciones)==lista or listaCanciones == None
    return fold(minDuracion, 100000, listaCanciones)
assert duracionMinimaListaCanciones(L)==8

# 0.2 PUNTOS
# Imprime en pantalla el listado de las canciones en 'listaCanciones' (ver dialogo de ejemplo mas abajo)
def imprimirListaCanciones(listaCanciones):
    mapa(imprimirCancion, listaCanciones)

# programa principal

# 0.4 PUNTOS
print "**** lista de canciones en el catalogo ****"
#print "Nro. de canciones disponibles:", contarCanciones(L)
print "Duracion total de las canciones:", duracionListaCanciones(L)
print "Cancion de duracion maxima (segs):", duracionMaximaListaCanciones(L)
print "Cancion de duracion minima (segs):", duracionMinimaListaCanciones(L)

imprimirListaCanciones(L)
print "*******************************************"

print "Detalles por género:"
genero = raw_input("Ingrese genero que desea consultar: ")

listaCancionesGenero = filtrarPorGenero(genero,L)
print "Listando canciones detalles del genero "+" \""+genero+"\""
#print "Nro. de canciones disponibles:", contarCanciones(listaCancionesGenero)
print "Duracion total de las canciones:", duracionListaCanciones(listaCancionesGenero)
print "Cancion de duracion maxima (segs):", duracionMaximaListaCanciones(listaCancionesGenero)
print "Cancion de duracion minima (segs):", duracionMinimaListaCanciones(listaCancionesGenero)

imprimirListaCanciones(listaCancionesGenero)