#cancion.py
import estructura
from abstraccion import *
from lista import *

#cancion: str str int
estructura.crear("cancion", "titulo genero duracion")


# 0.2 PUNTOS
# crea un elemento de tipo cancion con titulo, genero y duracion(seg)
# devuelve una cancion
def crearCancion(titulo, genero, duracion):
    assert type(titulo)==str and type(genero)==str and type(duracion)==int
    return cancion(titulo, genero, duracion)

# 0.5 PUNTOS
# crea un string que convierte la duracion de una cancion a un string en formato "mm:ss"
# devuelve el string
def aStringDuracionCancion(c):
    assert type(c) == cancion
    minutos = c.duracion/60
    segundos = c.duracion%60
    
    if (minutos) < 10:
        mins = "0"+str(minutos)
    else:
        mins = str(minutos)
    
    if (segundos) < 10:
        segs = "0"+str(segundos)
    else:
        segs = str(segundos)
    
    return mins +":"+ segs

assert aStringDuracionCancion(crearCancion("Hello", "Rock", 64))=="01:04"
assert aStringDuracionCancion(crearCancion("Hello", "Rock", 84))=="01:24"

# 0.3 PUNTOS
# imprime en pantalla los datos de una cancion como incluyendo su titulo, genero y
# duracion en formato "mm:ss" (ver dialogo de ejemplo)
def imprimirCancion(c):
    assert type(c) == cancion
    print ""
    print "----------------------"
    print "Cancion:"
    print "   Titulo:", c.titulo
    print "   Genero:", c.genero
    print "   Duracion:", aStringDuracionCancion(c)
    print "----------------------"
    
# funcion booleana que devuelve True o False segun si la cancion 'c' pertenece a 'genero'
def esGenero(c, genero):
    assert type(genero) == str and type(c)==cancion
    return genero == c.genero

# funcion que devuelve el resultado de sumar 'suma_duracion' y la duracion de la cancion 'c'
def sumaDuracion(suma_segundos, c):
    assert type(c)==cancion and type(suma_segundos)==int
    return suma_segundos + c.duracion
assert sumaDuracion(38,crearCancion("Hello", "Rock", 64))==102

# funcion que devuelve el maximo entre 'maximo_local' y la duracion de la cancion 'c'
def maxDuracion(max_segundos, c):
    assert type(c)==cancion and type(max_segundos)==int
    return max(max_segundos,c.duracion)
assert maxDuracion(38,crearCancion("Hello", "Rock", 64))==64

# funcion que devuelve el minimo entre 'min_local' y la duracion de la cancion 'c'
def minDuracion(min_segundos, c):
    assert type(c)==cancion and type(min_segundos)==int
    return min(min_segundos,c.duracion)
assert minDuracion(38,crearCancion("Hello", "Rock", 64))==38