from lista import *

from cerca import cerca

import math



#quintoElemento



# quintoElemento: lista(str) -> elemento

# entrega el quinto elemento de una lista de Strings, o None si no existe

# ejemplos: quintoElemento(crearLista('a',lista('c',crearLista('c',lista('d',crearLista('e',listaVacia)))))) entrega 'e'

def quintoElemento(lista):

    return quintoElementoRec(lista, 1)



def quintoElementoRec(lista, posicion):

    #casos bases

    if vacia(lista):

        return None

    elif posicion == 5:

        return cabeza(lista)

    #recursion

    else:

        return quintoElementoRec(cola(lista), posicion+1)



#test

assert quintoElemento(crearLista('a',crearLista('b',crearLista('c',crearLista('d',crearLista('e',listaVacia)))))) == 'e'







#cuentaElementos



# cuentaElementos: lista(any) -> num

# entrega el numero de elementos de una lista

# ejemplo: cuentaElementos(crearLista(1,crearLista(2,crearLista(3,crearLista(4,crearLista(5,listaVacia)))))) entrega 5

def cuentaElementos(lista):

    #caso base

    if vacia(lista):

        return 0

    #recursion

    else:

        return 1 + cuentaElementos(cola(lista))



#test

assert cuentaElementos(crearLista(1,crearLista(2,crearLista(3,crearLista(4,crearLista(5,listaVacia)))))) == 5







#pares



# pares: lista(int) -> lista(int)

# entrega una lista con los numeros pares de una lista previa

# ejemplo: pares(crearLista(2,crearLista(1,crearLista(3,crearLista(4,crearLista(5,listaVacia)))))) entrega crearLista(2,crearLista(4,listaVacia))



#Cuerpo funcion

def pares(lista):

    #caso base

    if vacia(lista):

        return listaVacia

    #recursion

    if cabeza(lista) % 2 == 0:

        return crearLista(cabeza(lista), pares(cola(lista)))

    else:

        return pares(cola(lista))



#test

assert pares(crearLista(2,crearLista(1,crearLista(3,crearLista(4,crearLista(5,listaVacia)))))) == crearLista(2,crearLista(4,listaVacia))







#perimetro



estructura.crear("punto3D", "x y z")



# distancia: punto3D punto3D -> float

# entregar la distancia total entre dos puntos

# distancia(puntos3D(1,2,3), puntos3D(2,3,4)) es sqrt(3)

def distancia(p1,p2):

    return math.sqrt((p1.x-p2.x)**2+(p1.y-p2.y)**2+(p1.z-p2.z)**2)



#test

epsilon = 0.00001

assert cerca(distancia(punto3D(1,2,3), punto3D(2,3,4)), math.sqrt(3), epsilon)



# perimetro: lista(punto3D) -> float

# entregar el perimetro total de la curva 3D

# ejemplo: perimetro(crearLista(punto3D(1,2,3), crearLista(punto3D(2,3,4), listaVacia))) es 2*sqrt(3)

def perimetro(lista):

    if vacia(lista):

        return 0.0

    else:

        return perimetroRec(lista, cabeza(lista))



def perimetroRec(lista, primero):

    if vacia(cola(lista)): #es el ultimo

        return distancia(cabeza(lista), primero)

    else:

        return distancia(cabeza(lista), cabeza(cola(lista))) +  perimetroRec(cola(lista), primero)



#test

assert cerca(perimetro(crearLista(punto3D(1,2,3), crearLista(punto3D(2,3,4), listaVacia))), 2*math.sqrt(3), epsilon)



#####################################################################



import random



# pideNumero: str int -> int

# devuelve un numero entero aleatorio mayor o igual que minimo

# ejemplo: pidenumero("numero? ", 1) devuelve 10

def pideNumero(mensaje, minimo):

    numero = input(mensaje)

    if type(numero) != int or numero < minimo:

        return pideNumero(mensaje, minimo)

    return numero



# juego: int int int -> None

# implemente el juego de adivinar un numero, recibe como parametros

# el numero a adivinar, el valor maximo y la cantidad de intentos ya realizados

def juego(num, n, intentos):

    numero = pideNumero("Adivina el numero [1," + str(n) + "]: ", 0)

    if numero == 0:

        print "Has perdido! El numero era " + str(num) + ". Lo intentaste " + str(intentos) + " veces."

        return

    elif numero == num:

        print "Has ganado! Lo adivinaste en " + str(intentos) + " intentos."

        return

    elif numero < num:

        print "El numero a adivinar es mayor que " + str(numero)

    else:

        print "El numero a adivinar es menor que " + str(numero)

    juego(num, n, intentos + 1)



# Programa

n = pideNumero("Valor inicial? ", 1)

juego(random.randint(1, n), n, 0)

