import estructura



# Datos compuestos



# 1.1



# persona: nombre(str) apellido(str) rut(str) edad(int)

estructura.crear("persona", "nombre apellido rut edad")



# 1.2



# mayorAlfabetico: persona persona -> persona

# entrega la persona con mayor apellido, lexicograficamente hablando

# ejemplo: mayorAlfabetico(persona("Jose", "Angel", 23213123, 39), persona("Juan", "Demonio", 2321312321, 39)) devuelve persona("Juan", "Demonio", 2321312321, 39)

def mayorAlfabetico(p1, p2):

    if p1.apellido > p2.apellido:

        return p1

    elif p2.apellido > p1.apellido:

        return p2

    elif p1.nombre> p2.nombre:

        return p1

    else:

        return p2



# Test

assert mayorAlfabetico(persona("Jose", "Angel", 23213123, 39), persona("Juan", "Demonio", 2321312321, 39)) == persona("Juan", "Demonio", 2321312321, 39)



# Listas



from lista import *



# 2.1

# despuesDeM

# No es tan facil ver como utilizar la funcion anterior para esto, pero tampoco es imposible. Simplemente compararemos con otra nueva persona que tenga como apellido M y nombre A, la cual servira para comprobar si viene o no despues

# Supondremos que M no es un apellido valido



# despuesDeM: lista(persona) -> lista(persona)

# entrega las personas con apellido lexicografico mayor a 'M'

# ejemplo: despuesDeM(lista(persona("Jose", "Angel", 23213123, 39), lista(persona("Juan", "Mdemonio", 2321312321, 39), listaVacia))) retorna una lista(persona("Juan", "Mdemonio", 2321312321, 39),listaVacia)

def despuesDeM(todos):

    if vacia(todos):

        return listaVacia

    elif mayorAlfabetico(cabeza(todos), persona("A", "M", 1, 1)) == cabeza(todos):

        return lista(cabeza(todos), despuesDeM(cola(todos)))

    else:

        return despuesDeM(cola(todos))



# Test

assert despuesDeM(lista(persona("Jose", "Angel", 23213123, 39), lista(persona("Juan", "Mdemonio", 2321312321, 39), listaVacia))) == lista(persona("Juan", "Mdemonio", 2321312321, 39),listaVacia)



#2.2

#edadPromedio

#para el promedio necesitamos el total y la suma, asi que lo calcularemos con funciones auxiliares



# suma: lista(persona)  -> int

# suma edades

# ejemplo: suma(lista(persona("Jose", "Angel", 23213123, 39), lista(persona("Juan", "Mdemonio", 2321312321, 39), listaVacia))) devuelve 78

def suma(unaLista):

    if vacia(unaLista):

        return 0

    else:

        return (cabeza(unaLista)).edad + suma(cola(unaLista))



# Test

assert suma(lista(persona("Jose", "Angel", 23213123, 39), lista(persona("Juan", "Mdemonio", 2321312321, 39), listaVacia)))==78





# total: lista(persona) -> num

# cuenta el total de personas en la lista

# ejemplos: total(lista(persona("Jose", "Angel", 23213123, 39), lista(persona("juan", "Mdemonio", 2321312321, 39), listaVacia))) devuelve 2

def total(unaLista):

    if vacia(unaLista):

        return 0

    else:

        return 1 + total(cola(unaLista))



# Test

total(lista(persona("Jose", "Angel", 23213123, 39), lista(persona("Juan", "Mdemonio", 2321312321, 39), listaVacia))) == 2





# promedioEdades: lista(persona) -> float

# devuelve el promedio de las edades en la lista

# ejemplo: promedioEdades(lista(persona("Jose", "Angel", 23213123, 41), lista(persona("Juan", "Mdemonio", 2321312321, 39), listaVacia))) devuelve 40

def promedioEdades(unaLista):

    return (float(suma(unaLista))) / total(unaLista)



# Test

from cerca import cerca

epsilon = 0.00001

assert cerca(promedioEdades(lista(persona("Jose", "Angel", 23213123, 41), lista(persona("Juan", "Mdemonio", 2321312321, 39), listaVacia))), 40, epsilon)



#2.3



# promedioDespuesDeM: lista(persona) -> num

# entrega el promedio de las edades en la lista de personas con apellidos mayores a M

# ejemplo: promedioDespuesDeM(lista(persona("Jose", "Angel", 23213123, 39), lista(persona("Juan", "Mdemonio", 2321312321, 39), listaVacia))) devuelve 39



def promedioDespuesDeM(lista):

    return promedioEdades(despuesDeM(lista))



# Test

assert cerca(promedioDespuesDeM(lista(persona("Jose", "Angel", 23213123, 39), lista(persona("Juan", "Mdemonio", 2321312321, 39), listaVacia))), 39, epsilon)





# Abstraccion Funcional



# filtro: (X -> bool) lista(X) -> lista(X)

# devuelve lista con todos los valores donde operador devuelve True

def filtro(operador, unaLista):

    if vacia(unaLista):

        return listaVacia

    else:

        if operador(cabeza(unaLista)):

            return lista(cabeza(unaLista), filtro(operador, cola(unaLista)))

        else:

            return filtro(operador, cola(unaLista))



# Tests

valores = lista(6, lista(4, lista(8, listaVacia)))

assert filtro(lambda x: x < 5, valores) == lista(4, listaVacia)

valores = lista('a', lista('b', lista('c', lista('d', listaVacia))))

assert filtro(lambda x: x >= 'b' and x < 'd', valores) == lista('b', lista('c', listaVacia))



# 3.1



# operador: persona -> bool

# devuelve True si el atributo apellido de la persona es mayor lexicograficamente que "M"

# ejemplo: operador("Perez") devuelve True

def operador(pers):

    return pers.apellido >= "M"



# despuesDeM: lista(persona) -> lista(persona)

# entrega las personas con apellido lexicografico mayor a 'M'

# ejemplo: despuesDeM(lista(persona("Jose", "Angel", 23213123, 39),

# lista(persona("Juan", "Mdemonio", 2321312321, 39), listaVacia)))

# retorna una lista(persona("Juan", "Mdemonio", 2321312321, 39),listaVacia)

def despuesDeM(todos):

    return filtro(operador, todos)

    # alternativamente, usando una funcion anonima

    # return filtro(lambda p: p.apellido >= 'M', todos)



# Test

assert despuesDeM(lista(persona("Jose", "Angel", 23213123, 39), lista(persona("Juan", "Mdemonio", 2321312321, 39), listaVacia))) == \

       lista(persona("Juan", "Mdemonio", 2321312321, 39),listaVacia)





# empresa: nombre(str) run(int) ltda(bool)

estructura.crear("empresa", "nombre run ltda")



# esLtda: empresa -> bool

# devuelve True si la empresa es de sociedad de responsabilidad limitada

def esLtda(emp):

    return emp.ltda



# empresasLtdas: lista(empresas) -> lista(empresas)

# devulelve la lista de empresas con sociedad de responsabilidad limitada

# ejemplo: si empresas = lista(empresa("Acme", 1234, True), lista(

#                 empresa("Omni", 1235, False), lista(

#                 empresa("Cyberdine", 1236, True), listaVacia)))

# empresasLtdas(empresas) devuelve lista(empresa("Acme", 1234, True), lista(

#                 empresa("Cyberdine", 1236, True), listaVacia))

def empresasLtdas(empresas):

    return filtro(esLtda, empresas)



# Tests

empresas = lista(empresa("Acme", 1234, True), lista(\

                 empresa("Omni", 1235, False), lista(\

                 empresa("Cyberdine", 1236, True), listaVacia)))

assert empresasLtdas(empresas) == lista(empresa("Acme", 1234, True), lista(\

                 empresa("Cyberdine", 1236, True), listaVacia))

