import random

# pertenece: num num num -> bool
# retorna el valor de verdad de la pertenencia de x en el intervalo [y,z]
# ej: pertenece(2,1,6)=True
def pertenece(x, y, z):
    return x >= y and x <= z

# test
assert pertenece(2, 1, 6) == True
assert pertenece(0, 1, 6) == False
assert pertenece(6, 1, 6) == True
assert pertenece(1, 1, 6) == True


# cachipun: num num -> num
# retorna el resultado del juego cachipun entre x e y. piedra=1, papel=2, tijera=3.
# ej: cachipun(2,1)=1
def cachipun(x, y):
    if not (pertenece(x, 1, 3) and pertenece(y, 1, 3)):
        return -1
    elif x == y:
        return 0
    elif x == 1:
        if y == 2:
            return 2
        else:
            return 1
    elif x == 2:
        if y == 1:
            return 1
        else:
            return 2
    else:
        if y == 1:
            return 2
        else:
            return 1

# test
assert cachipun(1, 9) == -1
assert cachipun(10, 2) == -1
assert cachipun(2, 2) == 0
assert cachipun(1, 2) == 2
assert cachipun(2, 1) == 1
assert cachipun(1, 3) == 1

# 2.3 Descomentar para usar
humano = input("Piedra(1),Papel(2) o Tijeras(3)?")
computador = random.randint(1, 3)
if computador == 1:
    valor_computador = "Piedra"
elif computador == 2:
    valor_computador = "Papel"
else:
    valor_computador = "Tijeras"

result = cachipun(humano, computador)
if result == -1:
    print "Su valor ingresado es invalido"
elif result == 0:
    print "Empate de", valor_computador
elif result == 1:
    print "Gano humano porque computador jugo", valor_computador
else:
    print "Gano computador porque jugo", valor_computador
