# 1.D



#__lados: int  

#__valor: int  	

class Dado:    	  



    #constructor: 

    #__init__: int -> Dado			

    #crea dado de L lados con valor inicial 0	

    #ej: D = Dado(6)				

    def __init__(self,L):                             		

        assert  type(L) == int and L > 1  #opcional

        self.__lados = L

        self.__valor = 0                  	



    #metodo lanzar:

    #lanzar: None -> None				

    #dado toma un valor al azar entre 1 y __lados	

    #ej: D.lanzar()					

    def lanzar(self):					

        import random

        self.__valor = random.randint(1,self.__lados)	



    #metodo valor:

    #valor: None -> int		

    #entrega valor del dado	

    #ej: D.valor()			

    def valor(self):		

        return self.__valor		



#testing: 

D = Dado(6)                 		

assert D.valor() == 0   		

D.lanzar()                    		

assert D.valor() in [1,2,3,4,5,6]



# 1.A



# lanzarDados: int int -> list(int)

def lanzarDados(N, L):

    lista = []           		

    for i in range(N):  	

        D = Dado(L)       	

        D.lanzar()      	

        lista.append(D) 	 

    return lista        	



# 1.B



# lanzarDados: list(Dados) -> list(int)

def valoresDados(listaDados):

    L = []                    	

    for D in listaDados:      

        v = D.valor()                 

        L.append(v)               

    L.sort()               	 

    L.reverse()            	 

    return L                	 



# 1.C



#dados del jugador A: 

A = lanzarDados(3,6)         	 

valoresA = valoresDados(A)    	

print "valores de los dados del jugador A:", valoresA 

#dados del jugador B: 

B = lanzarDados(3,6)          	

valoresB = valoresDados(B)   	 

print "valores de los dados del jugador B:", valoresB 



#determinar ganador: 

if valoresA > valoresB:      

    print "gana A"         	  

elif valoresB > valoresA:   

    print "gana B"          	  

else:

    print "empate"         





# 2.B



# union: list list -> list

# devuelve una lista con la union de los conjuntos x e y

def union(x, y):

    # ojo: 'lista = x' seria un error de aliasing

    lista = []

    for valor in x:

        lista.append(valor)

    for valor in y:

        if valor not in x:

            lista.append(valor)

    return lista



# Test

x = [3, 4]

y = [1, 2]

u = union(x, y)

u.sort()

assert u == [1, 2, 3, 4]



# inter: list list -> list

# devuelve una lista con la interseccion de los conjuntos x e y

def inter(x, y):

    lista = []

    for valor in x:

        if valor in y:

            lista.append(valor)

    return lista



# Test

x = [2, 4, 6, 8]

y = [1, 2, 3, 4, 5, 6, 7, 8]

i = inter(x, y)

i.sort()

assert i == [2, 4, 6, 8]



# resta: list list -> list

# devuelve una lista con la resta de los conjuntos x e y

def resta(x, y):

    lista = []

    for valor in x:

        if valor not in y:

            lista.append(valor)

    return lista



# Test

x = [1, 2, 3, 4, 5, 6, 7, 8]

y = [2, 4, 7, 10]

r = resta(x, y)

r.sort()

assert r == [1, 3, 5, 6, 8]



# 2.A



# difSimetrica: list list -> list

# devuelve una lista con el conjunto de elementos que estan en uno solo

def difSimetrica(x, y):

    return resta(union(x, y), inter(x, y))

    

# test

x = [1, 5, 6, 8]

y = [2, 5, 8, 9, 10]

ds = difSimetrica(x, y)

ds.sort()

assert ds == [1, 2, 6, 9, 10]

