

# Botellas representa a la clase de todos las botellas, independiente de su

# contenido, material, capacidad, etc

#

# Campos:

# capacidad_max: int

# contenido_actual: int

# material: str

# tipo_de_relleno: str

# marca: str



class Botella:

    

    # Constructor    

    def __init__(self, material, maximo):

        self.capacidad_max = maximo

        self.material = material

        self.contenido_actual = 0

        self.tipo_de_relleno = ""

        self.marca = ""

        

    # Mutadores y accesores



    # setContActual: int -> None

    # efecto: modifica la variable de instancia contenido_actual

    def setContActual(self, ca):

        self.contenido_actual = ca

             

    # setTipoRelleno: str -> None

    # efecto: modifica la variable de instancia tipo_de_relleno

    def setTipoRelleno(self, tr):

        self.tipo_de_relleno = tr

        

    # setMarca: str -> None

    # efecto: modifica la variable de instancia marca

    def setMarca(self, m):

        self.marca = m    



    # getContActual: None -> int

    # devuelve el valor almacenado en contenido_actual

    def getContActual(self):

        return self.contenido_actual    

    

    # getMarca: None -> str

    # devuelve el valor almacenado en marca

    def getMarca(self):

        return self.marca

        

    # getCapMax: None -> int

    # devuelve el valor almacenado en capacidad_maxima

    def getCapMax(self):

        return self.capacidad_max   

        

    # getTipoRelleno: None -> str

    # devuelve el valor almacenado en tipo_relleno

    def getTipoRelleno(self):

        return self.tipo_de_relleno 

        

    # getMaterial: None -> str

    # devuelve el valor almacenado en material

    def getMaterial(self):

        return self.material            

        

    # vaciarBotella: None -> None 

    # efecto: vacia toda la botella

    def vaciarBotella(self):

        self.setContActual(0)

    

    # darUnSorbo: None -> None

    # efecto: toma 20 cc (o lo que quede) de la botella

    def darUnSorbo(self):

        if self.getContActual() > 20:

            self.setContActual(self.getContActual() - 20)

        else:

            self.vaciarBotella()

            

    # llenarBotella: str -> None

    # efecto: llena la botella con el tipo asignado            

    def llenarBotella(self, tipo):

        self.vaciarBotella()

        self.setTipoRelleno(tipo)

        self.setContActual(self.getCapMax())

        

    # estaLlena: None -> bool

    # retorna True si la botella esta llena, o False en caso contrario

    def estaLlena(self):

        return self.getCapMax() == self.getContActual()

    

    # imprimir: None -> str

    # retorna un String con la informacion de la botella

    def imprimir(self):

        final = "Botella "

        if self.getMarca() == "":

            final += "sin marca, "

        else:

            final += "de marca " + self.getMarca()+", "

        if not self.getMaterial() == "":

            final += "hecha de " + self.getMaterial()+", "

        final += "llena de "

        if self.getTipoRelleno() == "":

            final += "algun brebaje desconocido "

        else:

            final += self.getTipoRelleno() + " "

        final += " con " + str(self.getContActual()) + "cc ocupados de un total de " + str(self.getCapMax()) + "cc."

        return final



    # aumentarContenido: int str -> None

    # efecto: aumenta la cantidad de liquido de uan botella, si coincide

    # con el que ya esta en la botella, lo acepta, sino, lo desecha.

    # Nunca se pasa del maximo

    def aumentarContenido(self, cant, tipo):

        if self.getTipoRelleno() == tipo:

            if cant > self.getCapMax() - self.getContActual():

                self.llenarBotella(tipo)

            else:

                self.setContActual(self.getContActual() + cant)

        

#Parte 1



botella1 = Botella("Vidrio", 1000)

botella1.setContActual(350)

botella1.setTipoRelleno("Coca-Cola")

botella1.setMarca("Coca-Cola Company")



print botella1.imprimir()



botella2 = Botella("Vidrio", 1000)

botella2.setContActual(500)

botella2.setTipoRelleno("Aguardiente")

botella2.setMarca("Antumapu")



print botella2.imprimir()



botella3 = Botella("Plastico", 2500)



botella2.darUnSorbo()

botella2.darUnSorbo()

botella2.darUnSorbo()

botella2.darUnSorbo()

botella2.darUnSorbo()



botella3.setContActual(botella1.getContActual() + botella2.getContActual())

botella1.vaciarBotella()

botella2.vaciarBotella()

botella3.setTipoRelleno("Piscola")



botella3.vaciarBotella()

