#1.1

# MCD: int int -> int
# Utiliza el algoritmo de Euclides para encontrar el maximo comun divisor entre dos numeros, de forma recursiva
# La idea es restarle al numero mayor el menor, hasta que ambos sean iguales. Dicho numero es el MCD
# ejemplo: MCD(4,8) devuelve 4

def MCD(entero1, entero2):
    if entero1 == entero2 :
        return entero1
    else:
        mayor = max(entero1, entero2)
        menor = min(entero1, entero2)
        return MCD(mayor-menor, menor)
        
#test
assert MCD(2,4) == 2
assert MCD(100,1) == 1
assert MCD(4,8) == 4
assert MCD(26,4) == 2


#1.2

# Primera solucion: funciones mutuamente recursivas

# esPar: int -> bool
# devuelve True si n es par, False en caso contrario
# ejemplo: esPar(4) devuelve True
def esPar(n):
    if n == 0:
        return True
    else:
        return esImpar(n -1)

# esImpar: int -> bool
# devuelve True si n es impar, False en caso contrario
# ejemplo: esImpar(4) devuelve False
def esImpar(n):
    if n == 0:
        return False
    else:
        return esPar(n -1)

# Tests
assert esPar(0)
assert esPar(4)
assert not esPar(7)


# Segunda solucion: una unica funcion recursiva

# esPar: int -> bool
# devuelve True si n es par, False en caso contrario
# ejemplo: esPar(4) devuelve True
def esPar(n):
    if n == 0:
        return True
    elif n - 1 == 0:
        return False
    else:
        return esPar(n - 2)        

# Tests
assert esPar(0)
assert esPar(4)
assert not esPar(7)

#1.3

# largoNumero: int -> int
# Recibe un entero y retorna la cantidad de cifras que posee
# largoNumero(12345) devuelve 5
def largoNumero(numero):
    if numero < 10:
        return 1
    else:
        return 1 + largoNumero(numero / 10)

# Test
assert largoNumero(12345) == 5
assert largoNumero(1) == 1
assert largoNumero(1000) == 4

#1.4

# numeroInvertido: int -> int
# Recibe un numero entero y  retorne otro entero que represente dicho numero con las cifras invertidas
# numeroInvertido(123) retorna 321
def numeroInvertido(numero):
    if largoNumero(numero) == 1:
        return numero
    else:
        return (numero % 10) * (10 ** (largoNumero(numero ) - 1)) + numeroInvertido(numero / 10)

# Test
assert numeroInvertido(123) == 321
assert numeroInvertido(666) == 666
assert numeroInvertido(1000) == 1
