#Es necesario el modulo estructura para resolver estos problemas

import estructura

# 1. Fracciones

# Diseno de la estructura
# fraccion: numerador(int) denominador(int)
estructura.crear("fraccion", "numerador denominador")

#funciones
# Plantilla
# de funcionConFraccioens(fraccion1, fraccion2):
#       fraccion1.numerador ... fraccion2.numerador
#       fraccion1.numerador ... fraccion2.denominador
#       fraccion1.denominador ... fraccion2.numerador
#       fraccion1.denominador ... fraccion2.denominador

#Suma

# SumaFracciones: fraccion fraccion -> fraccion
# Crear una nueva fraccion que corresponda a la suma de dos fracciones f1 y f2
# ejemplo: sumaFracciones(fraccion(1,2),fraccion(3,4)) devuelve fraccion(10,8)
def sumaFracciones(f1, f2):
    num = f1.numerador * f2.denominador + f1.denominador*f2.numerador
    den = f1.denominador * f2.denominador
    return fraccion(num, den)
    
# Test
assert sumaFracciones(fraccion(1, 2), fraccion(3, 4)) == fraccion(10, 8)
assert sumaFracciones(fraccion(1, 2), fraccion(1, 2)) == fraccion(4, 4)


#Resta

# restaFracciones: fraccion fraccion -> fraccion
# Crear una nueva fraccion que corresponda a la resta de dos fracciones f1 y f2
# ejemplo: restaFracciones(fraccion(1,2),fraccion(3,4)) devuelve fraccion(10,8)
def restaFracciones(f1, f2):
    num = f1.numerador * f2.denominador - f1.denominador * f2.numerador
    den = f1.denominador * f2.denominador
    return fraccion(num, den)
    
# Test
assert restaFracciones(fraccion(1, 2), fraccion(3, 4)) == fraccion(-2, 8)
assert restaFracciones(fraccion(1, 2), fraccion(1, 2)) == fraccion(0, 4)


#Multiplicacion

# multiplicacionFracciones: fraccion fraccion -> fraccion
# Crear una nueva fraccion que corresponda a la multiplicacion de dos fracciones f1 y f2
# ejemplo: multiplicacionFracciones(fraccion(1,2),fraccion(3,4)) devuelve fraccion(10,8)
def multiplicacionFracciones(f1,f2):
    num = f1.numerador * f2.numerador
    den = f1.denominador * f2.denominador
    return fraccion(num, den)
    
# Test
assert multiplicacionFracciones(fraccion(1, 2), fraccion(3, 4)) == fraccion(3, 8)
assert multiplicacionFracciones(fraccion(1, 2), fraccion(1, 2)) == fraccion(1,4)


#division

# divisionFracciones: fraccion fraccion -> fraccion
# Crear una nueva fraccion que corresponda a la division de dos fracciones f1 y f2
# ejemplo: divisionFracciones(fraccion(1,2),fraccion(3,4)) devuelve fraccion(10,8)
def divisionFracciones(f1,f2):
    num = f1.numerador * f2.denominador
    den = f1.denominador * f2.numerador
    return fraccion(num, den)
    
# Test
assert divisionFracciones(fraccion(1, 2), fraccion(3, 4)) == fraccion(4,6)
assert divisionFracciones(fraccion(1, 2), fraccion(1, 2)) == fraccion(2, 2)


# Simplificacion

# mcd: int int -> int
# Retorna em maximo comun divisor entre dos numeros enteros positivos
# ejemplo: mcd(4, 16) devuelve 4
def mcd(a,b):
	if b == 0:
		return a
	else:
		return mcd(b, a%b)
		
assert mcd(4, 16) == 4

# simplicacionFracciones: fraccion -> fraccion
# Crea una nueva fraccion con los valores de la fraccion entregada simplificados
# ejemplo: simplificacionFracciones(fraccion(5, 100)) devuelve fraccion(1, 20)
def simplificacionFracciones(frac):
	maxComDiv = mcd(frac.numerador, frac.denominador)
	num = frac.numerador / maxComDiv
	den = frac.denominador / maxComDiv
	return fraccion(num, den)

assert simplificacionFracciones(fraccion(5, 100)) == fraccion(1, 20)

#2. Tiempo

# Diseno de la estructura
# tiempo: horas (int) minutos (int)
estructura.crear("tiempo", "horas minutos")

# tiempo2str: tiempo -> str
# devuelve el tiempo t en formato "HH:MM"
# ejemplo: tiempo2str(tiempo(1,5)) devuelve "1:05"
def tiempo2str(t):
    if t.minutos < 10:
        return str(t1.horas) + ":" + "0" + str(t1.minutos)
    else:
        return str(t1.horas) + ":" + str(t1.minutos)
        

# enMinutos: tiempo -> int
# devuelve la cantidad equivalente en minutos desde la hora 00:00 a la entregada
# ejemplo: enMinutos(tiempo(9,4)) entrega 544
def enMinutos(t):
    return t.horas * 60 + t.minutos
    
# test
assert enMinutos(tiempo(3,50)) == 230
assert enMinutos(tiempo(0,0)) == 0


# sumar: tiempo tiempo -> tiempo
# devuelve la suma de dos tiempos. Debe respetar el formato de min<60
# ejemplo: sumar(tiempo(9,4), tiempo(3,40)) devuelve tiempo(12,44)
def sumaTiempo(t1, t2):
    minutos = t1.minutos + t2.minutos
    if minutos < 60:
        return tiempo(t1.horas + t2.horas, minutos)
    else:
        return tiempo(t1.horas + t2.horas+1, minutos-60)
    
# test
assert sumaTiempo(tiempo(9,4), tiempo(3,40)) == tiempo(12,44)
assert sumaTiempo(tiempo(1,50), tiempo(3,23)) == tiempo(5,13)


# menor: tiempo tiempo -> bool
# devuelve True si t1 < t2
# ejemplo: menor(tiempo(9,4), tiepo(3,40)) devuelve False
def menor(t1, t2):
    if t1.horas < t2.horas:
        return True
    elif t1.horas > t2.horas:
        return False
    elif t1.minutos < t1.minutos:
        return True
    else:
        return False
    
#test
assert menor(tiempo(3,40), tiempo(9,4))
assert not menor(tiempo(1,50), tiempo(1,23))
