#particionar: list int int -> int
#particiona L entre ip e iu (devuelve indice de pivote)
#ej: particionar(lista,0,len(lista)-1)

def particionar(L,ip,iu):
  #elegir pivote (por ejemplo: el primero)
  pivote=L[ip]
  #repetir hasta que indices se superen
  i=ip+1; j=iu #indices para menores y mayores/iguales
  while i<=j:
    #avanzar indice de menores
    while i<=j and L[i]<pivote: i+=1
    #retroceder indice de mayores o iguales
    while i<=j and L[j]>=pivote: j-=1
    #intercambiar menor con mayor
    if i<=j:
      L[i],L[j]=L[j],L[i]; i+=1; j-=1
  #pivote a su posicion final
  L[ip]=L[j]; L[j]=pivote
  return j


#quicksort: list int int -> None
#ordena L entre indices ip e iu
#ej: quicksort(lista,0,len(lista)-1)

def quicksort(L,ip,iu):
  #caso base(1 elemento)
	if ip>=iu: return

  #particionar (y obtener indice de pivote)
	i=particionar(L,ip,iu)

	quicksort(L,ip,i-1)

	quicksort(L,i+1,iu)


def mediana(lista):
    largo = len(lista)
    nuevaLista = []
    i = 0
    while (i<largo):
        nuevaLista.append(lista[i])
        i += 1
    quicksort(nuevaLista, 0, largo-1)
    return nuevaLista[(largo-1)/2]

lista = ["D","B","A","E","C"]
print lista
print mediana(lista) #escribe C
print lista[0:4]
print mediana(lista[0:4]) #escribe B
