import estructura
#Nodo
#Nodo: nombre(String), izq(Nodo), der(Nodo)
estructura.crear("Nodo","nombre izq der")

#tamano: Nodo -> int
#Entrega numero de nodos en preorden
#ej: tamano(Nodo("A",Nodo("B",Nodo("C",None,None),Nodo("D",None,None)),Nodo("E",Nodo("F",None,None),None)))-> 6

def tamano(unNodo):
    assert unNodo==None or type(unNodo)==Nodo
    if unNodo==None: return 0
    else: return 1 + tamano(unNodo.izq) + tamano(unNodo.der)

#esPadre: Nodo String String -> bool
#Entrega True en caso de que el primer string sea padre directo del segundo string en el rbol, y False en caso contrario.
#ej: tamano (unNodo)-> 6
def esPadre(unNodo, stringPadre, stringHijo):
    assert (unNodo==None or type(unNodo)==Nodo) and type(stringPadre)==String and type(stringHijo)==String
    if unNodo == None or (unNodo.izq==None and unNodo.der==None): return False
    else:
        if unNodo.valor == stringPadre:
            if unNodo.der==None:
                if unNodo.izq.valor == stringHijo: return True
            elif unNodo.izq==None:
                if unNodo.der.valor == stringHijo: return True
            else:
                if unNodo.izq.valor == stringHijo or unNodo.der.valor == stringHijo: return True
        else:
            return esPadre(unNodo.izq,stringPadre,stringHijo) or esPadre(unNodo.der,stringPadre,stringHijo)

#esAbuelo: Nodo String String -> bool
#Entrega True en caso de que el primer string sea abuelo directo del segundo string en el rbol, y False en caso contrario.
#ej: tamano (unNodo)-> 6
def esAbuelo(unNodo, stringAbuelo, stringNieto):
    assert (unNodo==None or type(unNodo)==Nodo) and type(stringAbuelo)==String and type(stringNieto)==String
    if unNodo == None or (unNodo.izq==None and unNodo.der==None): return False
    else:
        if unNodo.valor == stringAbuelo:
            if unNodo.der==None: return esPadre(unNodo.izq,unNodo.izq.valor,stringNieto)
            elif unNodo.izq==None: return esPadre(unNodo.der,unNodo.der.valor,stringNieto)
            else: return esPadre(unNodo.izq,unNodo.izq.valor,stringNieto) or esPadre(unNodo.der,unNodo.der.valor,stringNieto)
        else: return esAbuelo(unNodo.izq,stringAbuelo,stringNieto) or esAbuelo(unNodo.der,stringAbuelo,stringNieto)

#------------------------------------------------------------------------------------------------------------------
#AB
#AB: valor(int), izq(Nodo), der(Nodo)
estructura.crear("AB","valor izq der")

#esHeap: AB -> bool
#Recibe un rbol binario A y entrega True si es un heap
#ej: AB(2, AB(5,AB(7,None,None),AB(8,None,None)), AB(3,AB(6,None,None),None))) retorna True

def esHeap(ab):
    assert ab==None or type(ab)==AB
    if ab==None: return True
    else:
        if(ab.izq == None and ab.der==None): return True
        elif(ab.der == None): return ab.valor<=ab.izq.valor
        elif(ab.valor <= ab.izq.valor and ab.valor <= ab.der.valor): return esHeap(ab.izq) and esHeap(ab.der)
        else: return False

#menor: AB -> int
#Recibe un heap A y entrega el menor valor
#ej: menor(AB(2, AB(5,AB(7,None,None),AB(8,None,None)), AB(3,AB(6,None,None),None)))) retorna 2

def menor(ab):
    assert esHeap(ab)
    return ab.valor

#agregar: int AB -> AB
#Recibe un heap A y entrega un nuevo heap con el valor insertado
#ej: agregar(4,(AB(2, AB(5,AB(7,None,None),AB(8,None,None)), AB(3,AB(6,None,None),None)))) retorna AB(2, AB(5,AB(7,None,None),AB(8,None,None)), AB(3,AB(6,None,None),AB(4,None,None)))

def agregar(nuevoValor, ab):
    assert ab==None or type(ab)==AB
    if ab==None: return AB(nuevoValor, None, None)
    elif ab.izq==None && ab.valor<=nuevoValor:
        ab.izq=AB(nuevoValor, None, None)
        return ab
    elif ab.der==None && ab.valor<=nuevoValor:
        ab.der=AB(nuevoValor, None, None)
    else: #

# borrar: int nodo -> nodo
# devuelve ABB con los valores en el ABB ab pero sin el nodo que contenga valor
# ejemplo: con el ABB creado en tests anteriores
# borrarABB(15, ABB) devuelve crearNodo(gustavo, None, crearNodo(ivan, None, None))
def borrar(valor, ab):
    if ab == None:
        return None
    else:
        if valor < ab.valor: return ab
	elif valor > ab.valor:
            return crearNodo(ab.valor, borrar(valor,ab.izq), borrar(valor, ab.izq))
	else: # valor == ab.valor
            # Caso 1: borrar hoja
            if ab.izq == None and ab.der == None:
                return None
            # Caso 2: borrar nodo con un solo hijo
            elif ab.izq == None:
                return ab.der
            elif ab.der == None:
		return ab.izq
            # Caso 3: el caso dificil
            else:
                if ab.izq.valor<ab.der.valor:
                    menor = ab.izq.valor
                    nuevaIzq = borrar(menor, ab.izq)
                    return AB(menor, nuevaIzq, ab.der)
		else:
                    menor = ab.der.valor
                    nuevaDer = borrar(menor, ab.der)
                    return AB(menor, ab.izq, nuevaDer)
