import estructura
from persona import *
from Modulo_lista import *

#AB: valor(any), izq(AB), der(AB)
estructura.crear("AB", "valor izq der")

#insertarPersona: AB Persona -> AB
def insertarPersona(A, persona):
    assert A == None or type(A) == AB
    if A == None:
        return AB(persona, None, None)
    assert persona.nombre != A.valor
    if persona.nombre < A.valor.nombre:
        return AB(A.valor, insertarPersona(A.izq, persona), A.der)
    else:
        return AB(A.valor, A.izq, insertarPersona(A.der, persona))

#insertarLista: AB lista(Persona) -> AB
def insertarLista(A, listaPersonas):
    assert A == None or type(A) == AB
    if listaPersonas == None:
        return A
    else:
        A = insertarPersona(A, cabeza(listaPersonas))
        return insertarLista(A, cola(listaPersonas))

#primero: AB -> Persona
def primero(A):
    assert A != None or type(A) == AB
    if A.izq == None:
        return A.valor
    else:
        return primero(A.izq)

#ultimo: AB -> Persona
def ultimo(A):
    assert A != None or type(A) == AB
    if A.der == None:
        return A.valor
    else:
        return primero(A.der)

#cantidadDe: AB str -> int
def cantidadDe(A, g):
    assert A == None or type(A) == AB
    if A == None:
        return 0
    else:
        if A.valor.genero == g:
            return 1 + cantidadDe(A.izq, g) + cantidadDe(A.der, g)
        return cantidadDe(A.izq, g) + cantidadDe(A.der, g)

#mayorQue: AB int -> int	
def mayorQue(A, edad):
    assert A == None or type(A) == AB
    if A == None:
        return 0
    else:
        if A.valor.edad > edad:
            return 1 + mayorQue(A.izq, edad) + mayorQue(A.der, edad)
        return mayorQue(A.izq, edad) + mayorQue(A.der, edad)

#equilibrado: AB -> bool
def equilibrado(A):
    assert A == None or type(A) == AB
    if A == None:
        return True
    elif (A.izq == None and A.der != None) or (A.der == None and A.izq != None):
        return False
    else:
        return equilibrado(A.izq) and equilibrado(A.der)

#aLista: AB -> lista(Persona)
def aLista(A):
    assert A == None or type(A) == AB
    if A == None:
        return None
    elif A.izq == None and A.der == None:
        return lista(A.valor, None)
    else:
        L1 = lista(A.valor, None)
        L2 = aLista(A.izq)
        L3 = aLista(A.der)
        return juntar(juntar(L2,L1), L3)      
    
        
    
B = Persona("Juan", 18, "H")
C = Persona("Jose", 20, "H")
D = Persona("Maria", 89, "M")
E = Persona("Sandra", 15, "M")

L = lista(B, lista(C, lista(D, None)))
A = None
AB3 = insertarLista(A, L)
pr = primero(AB3)
ul = ultimo(AB3)
hom = cantidadDe(AB3, "H")
muj = cantidadDe(AB3, "M")
num = mayorQue(AB3, 17)
