from Modulo_lista import *
from animal import *

#esClase: Animal str -> bool
def esClase(A, x):
    return A.Clase == x

#esClase: Animal str -> bool
def noEsClase(A, x):
    return not esClase(A,x)

#esClase: Animal str -> bool
def esEspecie(A,x):
    return A.Especie == x

#esClase: Animal str -> bool
def noEsEspecie(A,x):
    return not esEspecie(A,x)

#esClase: Animal str -> bool
def esDieta(A,x):
    return A.Dieta == x

#esClase: Animal str -> bool
def noEsDieta(A,x):
    return not esDieta(A,x)

#filtro: funcion lista str -> lista
def filtro(comparacion, L, x):
    assert esLista(L)
    if L == None:
        return None
    elif comparacion(cabeza(L), x):
        return lista(cabeza(L), filtro(comparacion, cola(L), x))
    else:
        return filtro(comparacion, cola(L), x)

#aAnhos: Animal -> Animal        
def aAnhos(A):
    A = Animal(A.Especie, A.Clase, A.Dieta, A.Edad/12)
    return A

#mapa: funcion, lista -> lista
def mapa(funcion, L):
    assert esLista(L)
    if L == None:
        return None
    else:
        nuevaCabeza = funcion(cabeza(L))
        nuevaCola = mapa(funcion, cola(L))
        return lista(nuevaCabeza, nuevaCola)

#frecuenciaEspecies: lista(Animales) -> lista(str)
def frecuenciaEspecie(L):
    assert esLista(L)
    if L == None:
        return None
    else:
        a = cabeza(L).Especie
        L2 = filtro(noEsEspecie, cola(L), a)
        L1 = lista(a, frecuenciaEspecie(L2))
        return L1

#cantidad: lista(str) lista(Animales) -> lista(int)
def cantidad(LE, LA):
    assert esLista(LE) and esLista(LA)
    if LE == None or LA == None:
        return 0
    else:
        a = cabeza(LE)
        L1 = filtro(esEspecie, LA, a)
        largoA = largo(L1)
        L4 = lista(largoA, cantidad(cola(LE), LA))
        return L4

#frecuencia: lista -> lista(str), lista(int)
def frecuencia(L):
    LE = frecuenciaEspecie(L)
    return LE, cantidad(LE, L)

#cambioDieta: Animal -> Animal
def cambioDieta(A):
    assert A.Dieta == "Carnivoro" or A.Dieta == "Hervivoro" or A.Dieta == "Omnivoro"
    if(A.Dieta == "Carnivoro"):
        a = "Come Carne"
    elif(A.Dieta == "Hervivoro"):
        a = "Come Plantas"
    elif(A.Dieta == "Omnivoro"):
        a = "Come Todo"
    A = Animal(A.Especie, A.Clase, a, A.Edad)
    return A

#esAmbos: Animal str str -> bool
def esAmbos(A,x,y):
    return esClase(A,x) and esDieta(A,y)

#filtroAmbos: funcion Lista str str -> lista
def filtroAmbos(comparacion, L, x, y):
    assert esLista(L)
    if L == None:
        return None
    elif comparacion(cabeza(L), x, y):
        return lista(cabeza(L), filtroAmbos(comparacion, cola(L), x, y))
    else:
        return filtroAmbos(comparacion, cola(L), x, y)
    
A = Animal("Perro", "Mamifero", "Carnivoro", 20)
B = Animal("Leon", "Mamifero", "Carnivoro", 30)
C = Animal("Conejo", "Mamifero", "Hervivoro", 80)
D = Animal("Rana", "Anfibio", "Carnivoro", 15)
E = Animal("Tiburon", "Pez", "Carnivoro", 17)
F = Animal("Picaflor", "Ave", "Hervivoro", 34)
G = Animal("Avestruz", "Ave", "Omnivoro", 50)
H = Animal("Tortuga", "Reptil","Omnivoro", 20)
I = Animal("Rana", "Anfibio", "Carnivoro", 35)
listaAnimales=lista(A, lista(B, lista(C, lista(D, lista(E, lista(F, lista(G, \
                    lista(H, lista(I, None)))))))))
