# -*- coding: utf-8 -*-
import estructura

#Diseño Estructura
#Trabajo: Nombre(str) TipoPago(str) MontoPago(int) Horas(int)
estructura.crear("Trabajo", "Nombre TipoPago MontoPago Horas")

t = Trabajo("Auxiliar", "UB", 8, 10)
tp = Trabajo("Programador", "CLP", 200000, 20)

#UBaCLP: int
#Transforma UBs en CLP
#Ej: UBaCLP(2) retorna 18000
def UBaCLP(x):
    assert type(x) == int
    return x*9000

#Test
assert UBaCLP(2) == 18000

#precioHora: Trabajo
#Retorna el pago por hora en CLP
#Ej: precioHora(t) retorna 1800
def precioHora(x):
    assert type(x) == Trabajo
    assert x.Horas> 0
    pago = 0
    if x.TipoPago == "UB":
        pago = UBaCLP(x.MontoPago)
    else:
        pago = x.MontoPago
    return pago/(x.Horas*4)

#Test
assert precioHora(t) == 1800
assert precioHora(tp) == 2500


#compararTrabajos: Trabajo Trabajo
#Determina que trabajo retorna mayor paga, entregando 1 si t1 paga mejor que t2,
#0 si pagan lo mismo y -1 si t2 paga mejor
#Ej:compararTrabajos(t, tp) retorna -1
def compararTrabajos(t1, t2):
    assert ((type(t1) == Trabajo) & (type(t2) == Trabajo)), "Debe ingresar Trabajos"
    pago1 = precioHora(t1)
    pago2 = precioHora(t2)
    if pago1 > pago2:
        return 1
    elif pago1 == pago2:
        return 0
    else:
        return -1
#Test
assert compararTrabajos(t, tp) == -1

#mejorTrabajo: Trabajo Trabajo
#Retorna el trabajo que pague mejor por hora
#Ej: mejorTrabajo(t, tp) retorna tp
def mejorTrabajo(t1, t2):
    if compararTrabajos(t1, t2) >= 0:
        return t1
    else:
        return t2

#Test
assert mejorTrabajo(t, tp) == tp

#Programa Interactivo

inicio = Trabajo("Vacio", "CLP", 0, 1)

def ingresoTrabajo():
    nombre = raw_input("Nombre? ")
    if nombre == "0":
        return inicio
    modoPago = raw_input("Modo de Pago? ")
    pagoMensual = input("Pago Mensual? ")
    horas = input("Horas de trabajo semanal? ")
    return Trabajo(nombre, modoPago, pagoMensual, horas)

def dialogo(t):
    print "________________________________________________________"
    t1 = ingresoTrabajo()
    if t1 == inicio:
        print "________________________________________________________"
        if t == inicio:
            print "No nos diste ningun trabajo!"
            return
        else:
            print "El mejor trabajo es ser " + t.Nombre + " por un pago de " + str(precioHora(t)) + "CLP la hora."
            return 
    else:
        print "Pago por hora al mes: ", precioHora(t1), "CLP"
        return dialogo(mejorTrabajo(t,t1))
    
def programa():
    print "Bienvenido a la super calculadora de pago horario,"
    print "ingrese su consulta (0 para terminar)"
    
    dialogo(inicio)
    print "Muchas Gracias por preferirnos!"

programa()

A = Trabajo("A", "UB", 12, 12)
B = Trabajo("B", "UB", 8, 4)
C = Trabajo("C", "CLP", 180000, 30)

