function [x, y] = dibujar(T)
    n = size(T, 1);
    arco = 2 * pi / n;
    angulo = 0;
    x = 1;
    y = 1;
    r = 2*n;
    for i = 2:n
        x(i) = x(i-1) + r*cos(angulo);
        y(i) = y(i-1) + r*sin(angulo);
        angulo = angulo + arco;
    end
    plot(x, y, '*')
    
    hold on
    for i = 1:n
        for j = 1:n
            if T(i, j)
                quiver(x(i), y(i), x(j) - x(i), y(j) - y(i), 0, '-b')
            end
        end
    end

    hold off
end
