function [Ablack,Abare,Awhite,Temission,Trock,Tblack,Twhite,Ap,Tsun] = daisyworldb(Ablack,Awhite,transfer,black,bare,white,S,q,death,startarea,lowgrowthK,highgrowthK)


% Argument checking 
if nargin < 12
  disp('Error- Incorrect number of arguments given to function.') 
end
if lowgrowthK>=highgrowthK
  disp('Error- Enter a lower and higher temperature (in K) for the daisy growth limits.')
end
if black>=white | bare>white | bare<black
  disp('Error- Please enter increasing black, bare and white albedos respectively.') 
end

SB=5.669*10^-8; %sets the Stefan-Boltzman constant

% Calculate the area of bare ground 
Abare=1-Ablack-Awhite;
% Calculates the average planetary albedo 
Ap=Abare*bare+Awhite*white+Ablack*black;

% Calculates average emission temperature according to Ap 
Tsun=((S/SB)*(1-Ap))^0.25;
Temission = transfer+Tsun;

% Temperature of lifeless 'rock' for comparison 
Trock = ((S/SB)*(1-bare))^0.25;

% Local temperature around each coloured daisies 
Tblack=q*(Ap-black)+Temission; 
Twhite=q*(Ap-white)+Temission;

% Calculate each daisy's growthrate according to temperature
betab = beta(lowgrowthK,highgrowthK,Tblack); 
growthb = Ablack*(betab*Abare-death); 
betaw = beta(lowgrowthK,highgrowthK,Twhite); 
growthw = Awhite*(betaw*Abare-death);

% Calculate areas of daisies 
Ablack = Ablack+growthb; 
Awhite = Awhite+growthw;

% Check for no negative area 
if Ablack<=startarea
   Ablack=startarea; 
end
if Ablack>1 
   Ablack=1;
end
if Awhite<=startarea
   Awhite=startarea; 
end
if Awhite>1 
   Awhite=1;
end
