function daisyice1(lower,upper)
global Ablack Awhite Abare Tblack Twhite Ap;
numba=100;
% Calculate number of time steps (numba per 3 billion years) 
length=(upper-lower)*numba;
S = 1000; %sets the current solar luminosity 

jump=(upper*S-lower*S)/(length-1);
E(1,1)=lower*S; %initialises the lower limit relative to todays insolation 

for y = 2:length
    E(y,1) = E(y-1,1) + jump; %creates the column matrix of increasing solar Energy 
end
										   
% Initialise arguments for function daisyworld 
startarea = 0.05;
q = 20;
death = 0.2;
lowgrowthK = 278; 
highgrowthK = 313; 
black = 0.25; 
bare = 0.5; 
white = .75; 
latdiv = 179; 
heatcon = .75; 
icealbedo = 0.65; 
outgoingheat = .9;

inc = 180/latdiv;
lat = [(0+inc):inc:(180-inc)]; %creates lat, column of latitude degrees 
SB = 5.669*10^-8; %sets the Stefan-Boltzman constant

[c,d] = size(lat); 
AB = startarea*ones(d,1); 
AW = startarea*ones(d,1); 
AP = zeros(d,1);
transfer = zeros(d,1);

% Start loop for each time increment 
for  a = 2:length+1
     Ecurrent=E(a-1,1); 
     for b = 1:d
	 S = dsin(lat(1,b))*Ecurrent;  % Defines the energy received at each latitude
         % Call function and store results
         [Ablackresults(b,a-1),Abareresults(b,a-1),Awhiteresults(b,a-1),Temissionresults(b,a- 1),Trockresults(b,a-1),Tblackresults(b,a-1),Twhiteresults(b,a-1),AP(b,1),Tsun(b,a- 1)] = daisyworldb(AB(b,1),AW(b,1),transfer(b,1),black,bare,white,S,q,death,startarea,lowgro wthK,highgrowthK);
         AB(b,1) = Ablackresults(b,a-1); 
         AW(b,1)=Awhiteresults(b,a-1);

%ice statement
if Temissionresults(b,a-1)<=263
     AP(b,1)=icealbedo;
elseif Temissionresults(b,a-1)<=273 & Temissionresults(b,a-1)>263
     AP(b,1)=icealbedo-((Temissionresults(b,a-1)-263)/10)*(icealbedo-bare); 
end
Apresults(b,a-1)=AP(b,1); 
end
%creates mirror image for opposite latitudes (there are more elegant ways to do this) 

for f=((round(d/2)+1)):d
    Temissionresults(f,a-1) = Temissionresults(f,a-1)+heatcon*(1-(round(d)/2)*exp(- (1/q)*f))*(Temissionresults(f-1,a-1)-Temissionresults(f,a-1));
    Temissionresults((d-f+1),a-1) = Temissionresults(f,a-1); 
end
transfer(:,1)=outgoingheat*(Temissionresults(:,a-1)-Tsun(:,a-1)); 
end



[g,h]=size(lat);

%plot the results
figure(1) 
surf(1:length,1:h,Temissionresults) 
xlabel('Time')
ylabel('Latitude') 
zlabel('Temperature (K)')
shading interp;

figure(2)
subplot(2,1,1) pcolor(1:length,1:h,Apresults) 
shading interp;
colormap(gray);
title('Greyscale map of albedo') 
xlabel('Time')
ylabel('Latitude')
hold on;
subplot(2,1,2) 
plot(1:length,mean(Apresults)) 
xlabel('Time')
ylabel('Mean planetary albedo') 

figure(3)
subplot(3,1,1) 
surf((1:length),1:h,Ablackresults) 
shading interp; 
text(3,latdiv,0.9,'Black daisy area') 
hold on;
xlabel('Time')
ylabel('Latitude')

subplot(3,1,2) 
surf((1:length),1:h,Awhiteresults) 
shading interp;
hold on;
text(3,latdiv,0.9,'White daisy area') 
xlabel('Time')
ylabel('Latitude')

subplot(3,1,3) 
surf((1:length),1:h,Awhiteresults+Ablackresults) 
shading interp;
text(3,latdiv,0.9,'Total daisy area') 
xlabel('Time')
ylabel('Latitude')
