% function to include CO2 feedback
function daisyCO21(lower,upper)
disp('Programm to run daisyworld with CO2 feedback')
% Global Ablack Awhite Abare Tblack Twhite Ap;

% Initialise arguments for function daisyworld 
startarea = 0.05;
q = 20;
death = 0.2;
lowgrowthK  = 278; 
highgrowthK = 313; 
black = 0.25; 
bare =  0.5;
white = .75;
latdiv = 179;
heatcon = .75; %proportional to latitudinal conduction of heat (0,1) 
outgoingheat = .9; %proportional to heat capacity (0,1)
range = 2; %intensity of CO2 greenhouse effect (K)
const = 1; %inversely prop. to growth restriction by CO2 (use 1 - 5)
numba = 100; %number of timesteps for given insolation increase

% Calculate number of time steps (numba per 3 billion years) 
length = (upper-lower)*numba;
if round(length)~=length
  length = round(length); 
end

S = 1000; % Sets the current solar luminosity 
jump = (upper*S-lower*S)/(length-1);
E(1,1) = lower*S; % Initialises the lower limit relative to todays insolation 

for y = 2:length
    E(y,1) = E(y-1,1) + jump; % creates the column matrix of increasing solar Energy
end

inc = 180/latdiv; 
lat = [(0+inc):inc:(180-inc)]; % Creates lat, column of latitude degrees 
SB = 5.669*10^-8; % Sets the Stefan-Boltzman constant
															   
carbon = 200; % Total CO2 in model
carb = carbon/latdiv; % CO2 in atmosphere (per latitude)

% Argument checking
if lowgrowthK>=highgrowthK
  disp('Error- Enter a proper temperature range (in K) for the daisy growth limits.') 
end
if black>=white | bare>white | bare<black
  disp('Error- Please enter increasing black, bare and white albedos respectively.')
end

[c,d] = size(lat);
AB = startarea*ones(d,1); 
AW = startarea*ones(d,1);
AP = zeros(d,1);
transfer = zeros(d,1); 

% For heat transfer 
carblat = carb*ones(d,1); 
carbav  = mean(carblat); 
totalcarb = zeros(1,length);
%start loop for each time increment 
for a = 2:length+1
    Ecurrent = E(a-1,1);
    % Start loop for each latitude division 
    for b = 1:d
	S = sind(lat(1,b))*Ecurrent; %defines the energy received at each latitude
	if carblat(b,1) < 0 
           carblat(b,1) = 0;
        end
        if carblat(b,1) > carb
           carblat(b,1) = carb; 
        end
        % Call function and store results
	[Ablackresults(b,a-1),Abareresults(b,a-1),Awhiteresults(b,a-1),Temissionresults(b,a-1),Trockresults(b,a-1),Tblackresults(b,a-1),Twhiteresults(b,a-1),Apresults(b,a-1),Tsun(b,a-1)] = daisyworldc(AB(b,1),AW(b,1),transfer(b,1),carb,carbav,range,black,bare,white,S,q,death,startarea,lowgrowthK,highgrowthK,const);
        AB(b,1) = Ablackresults(b,a-1); 
        AW(b,1) = Awhiteresults(b,a-1); 
        AP(b,1) = Apresults(b,a-1); 
        carblat(b,1) = carb - (AB(b,1) + AW(b,1));
    end
    % Transfers heat & creates mirror image for opposite latitudes (there are more elegant  ways to do this)
    for f = ((round(d/2)+1)):d
	Temissionresults(f,a-1) = Temissionresults(f,a-1)+heatcon*(1-(round(d)/2)*exp(- (1/q)*f))*(Temissionresults(f-1,a-1)-Temissionresults(f,a-1));
        Temissionresults((d-f+1),a-1) = Temissionresults(f,a-1); 
    end
    totalA(a-1,1) = sum(AW)+sum(AB); 
    transfer(:,1) = outgoingheat*(Temissionresults(:,a-1)-Tsun(:,a-1)); 
    carbav = mean(carblat);
    totalcarb(1,a-1) = sum(carblat);
end

[g,h]=size(lat);

% Plot the results
figure(1) 
surf(1:length,1:h,Temissionresults) 
xlabel('Time')
ylabel('Latitude') 
zlabel('Temperature (K)') 
shading interp;

figure(2)
subplot(2,1,1) 
pcolor(1:length,1:h,Apresults) 
shading interp;
colormap(gray);
title('Greyscale map of albedo') 
xlabel('Time')
ylabel('Latitude')
hold on;

subplot(2,1,2) 
plot(1:length,mean(Apresults)) 
xlabel('Time')
ylabel('Mean planetary albedo') 

figure(3)
subplot(3,1,1) 
surf((1:length),1:h,Ablackresults) 
shading interp;
text(3,latdiv,0.9,'Black daisy area') 
hold on;
xlabel('Time')
ylabel('Latitude')

subplot(3,1,2)
surf((1:length),1:h,Awhiteresults)
shading interp;
hold on;
text(3,latdiv,0.9,'White daisy area')
xlabel('Time')
ylabel('Latitude')

subplot(3,1,3) 
surf((1:length),1:h,Awhiteresults+Ablackresults) 
shading interp;
text(3,latdiv,0.9,'Total daisy area')
xlabel('Time')
ylabel('Latitude')

figure(4)
subplot(2,1,1)
plot(1:length,totalcarb)
axis([1 length 0 carb*latdiv])
xlabel('Time')
ylabel('Carbon in atmosphere (parts)') 
subplot(2,1,2)
plot(1:length,totalA)
xlabel('Time')
ylabel('Total daisy area (terrestrial carbon storage)')
