% Pauta Control Experimental Nº3 - F 
% Semestre Primavera 2017
% Prof: C Falcon, M Flores, R Mendez
% Autor: José Ogalde Ortiz

%% Parte A - Regresion Lineal
% Prob encontrar un foton -  modelo semilogx P = alpha*exp(beta*T)
% Se pide calcular los valores (alpha, beta) y R^2 del modelo linealizado

% Datos experimentales
T = [0.1 0.35 1.32 2.55 4.30]; % [seg]
P = [0.860 0.592 0.138 0.021 0.002]; % [Hz]

yi = log(P);
xi = T;

% Sumas sobre los datos experimentales
N = length(xi);
Sxiyi = sum(xi.*yi);
Sxi = sum(xi);
Syi = sum(yi);
promYi = mean(yi);
promXi = mean(xi);
Sxi2 = sum(xi.*xi);

%Calculo de pendiente y constante de regresion lineal
coeffA = ((Sxiyi/Sxi)-(Syi/N))/((Sxi2/Sxi) - (Sxi/N))
coeffB = (Syi/N) - (coeffA*(Sxi/N))
beta = coeffA
alpha = exp(coeffB)

%Calculo de desempeño R² y evaluacion del modelo yi_m usando valores xi
yiModelo = coeffA.*xi + coeffB;
Syi_promYi2 = sum((yi-promYi).^2);
SyiModelo_yi2 = sum((yiModelo-yi).^2);

R2 = 1 - (SyiModelo_yi2/Syi_promYi2)

%% Plot de la regresion
figure;
% Graficamos todo en escala log10
subplot(2,1,1);
plot(xi,yi, 'o');
hold on;
grid on;
plot(xi,yiModelo,'*');
xtemp = linspace(min(xi), max(xi), 100);
modeloLinealEscalaLog = coeffA.*xtemp + coeffB; %lo mismo que antes pero con mayor discretizacion
plot(xtemp, modeloLinealEscalaLog,'-');
legend('datos experimentales', 'modelo evaluado en los puntos','modelo completo','Location','eastoutside');
xlabel('Tiempo de espera [seg]');
ylabel('Probabilidad [log10(Hz)]');
title(['Ajuste lineal en escala logaritmica \alpha= ',num2str(alpha),' \beta= ',num2str(beta)]);

% Graficamos todo en escala real (tambien llamada escala lineal)
subplot(2,1,2);
yiModelo_escalalineal = alpha*(exp(beta.*T));
Ttemp = linspace(min(T), max(T), 100);
modeloLinealEscalaLineal = alpha*(exp(beta.*Ttemp));
plot(T,P,'o');
hold on;
grid on;
plot(T,yiModelo_escalalineal, '*');
plot(Ttemp, modeloLinealEscalaLineal,'-');
legend('datos experimentales', 'modelo evaluado en los puntos','modelo completo','Location','eastoutside');
xlabel('Tiempo de espera [seg]');
ylabel('Probabilidad [Hz]');
title(['Ajuste lineal en escala lineal \alpha= ',num2str(alpha),' \beta= ',num2str(beta)]);