% Pauta Control Experimental Nº3 - K 
% Semestre Primavera 2017
% Prof: C Falcon, M Flores, R Mendez
% Autor: José Ogalde Ortiz

%% Parte A - Regresion Lineal
% Ley de Kepler -  modelo ley de potencia T = C*(a^beta)
% Se pide calcular los valores (C, beta) y R^2 del modelo linealizado

% Datos experimentales (Brahe 1590)
T = [88 687 225 365 4307]; % [día]
a = [57911000 227940000 108200000 146600000 778330000]; % [km]

yi = log10(T);
xi = log10(a);

% Sumas sobre los datos experimentales
N = length(xi);
Sxiyi = sum(xi.*yi);
Sxi = sum(xi);
Syi = sum(yi);
promYi = mean(yi);
promXi = mean(xi);
Sxi2 = sum(xi.*xi);

%Calculo de pendiente y constante de regresion lineal
coeffA = ((Sxiyi/Sxi)-(Syi/N))/((Sxi2/Sxi) - (Sxi/N))
coeffB = (Syi/N) - (coeffA*(Sxi/N))
beta = coeffA
C = 10^(coeffB)

%Calculo de desempeño R² y evaluacion del modelo yi_m usando valores xi
yiModelo = coeffA.*xi + coeffB;
Syi_promYi2 = sum((yi-promYi).^2);
SyiModelo_yi2 = sum((yiModelo-yi).^2);

R2 = 1 - (SyiModelo_yi2/Syi_promYi2)

%% Sort de los datos de forma creciente (opcional)
[aa, indices] = sort(a);
T = T(indices);
a = a(indices);
xi = xi(indices);
yi = yi(indices);
yiModelo = yiModelo(indices);

%% Plot de la regresion
figure;

% Graficamos todo en escala log10
subplot(2,1,1);
plot(xi,yi, 'o');
hold on;
grid on;
plot(xi,yiModelo,'*');
xtemp = linspace(min(xi), max(xi), 100);
modeloLinealEscalaLog = coeffA.*xtemp + coeffB; %lo mismo que antes pero con mayor discretizacion
plot(xtemp, modeloLinealEscalaLog,'-');
legend('datos experimentales', 'modelo evaluado en los puntos','modelo completo','Location','eastoutside');
xlabel('Distancia al Sol [log10(km)]');
ylabel('Periodo [log10(dia)]');
title(['Ajuste lineal en escala logaritmica C= ',num2str(C),' \beta= ',num2str(beta)]);

% Graficamos todo en escala real (tambien llamada escala lineal)
subplot(2,1,2);
yiModelo_escalalineal = C*(a.^(beta));
atemp = linspace(min(a), max(a), 100);
modeloLinealEscalaLineal = C*(atemp.^(beta));
plot(a,T,'o');
hold on;
grid on;
plot(a,yiModelo_escalalineal, '*');
plot(atemp, modeloLinealEscalaLineal,'-');
legend('datos experimentales', 'modelo evaluado en los puntos','modelo completo','Location','eastoutside');
xlabel('Distancia al Sol [km]');
ylabel('Periodo [dia]');
title(['Ajuste lineal en escala lineal C= ',num2str(C),' \beta= ',num2str(beta)]);