package tests;

import static org.junit.Assert.*;

import org.junit.BeforeClass;
import org.junit.Test;

import platforms.*;
import contents.*;

import java.util.*;

public class Cadcc {

  static Hashtable<String, IPlatform> PLATFORMS = new Hashtable<>();
  static IPlatform BLOG, FACEBOOK, SCREEN, TELEGRAM, TWITTER, UCURSOS;
  static IContent NOTICE, POSTER, VIDEO;

  @BeforeClass
  public static void preparePlatforms() {
    BLOG = new Blog();
    FACEBOOK = new Facebook();
    SCREEN = new Screen();
    TELEGRAM = new Telegram();
    TWITTER = new Twitter();
    UCURSOS = new UCursos();
    NOTICE = new Notice("Bienvenida Mechona 2017", "28 de agosto", "Ven a la bienvenida!");
    POSTER = new Poster("https://www.cadcc.cl/wp-content/uploads/2017/08/BienvenidaParcelazo.png",
        "Afiche Parcelazo");
    VIDEO = new Video("Semana Computina!", "Video de la Semana Computina",
        "https://www.youtube.com/watch?v=atJ3CYpMggE");
  }

  @Test
  public void testBlog() {
    boolean noticeResult = NOTICE.postIn(BLOG);
    boolean posterResult = POSTER.postIn(BLOG);
    boolean videoResult = VIDEO.postIn(BLOG);
    assertTrue(noticeResult);
    assertTrue(posterResult);
    assertTrue(videoResult);
  }

  @Test
  public void testFacebook() {
    boolean noticeResult = NOTICE.postIn(FACEBOOK);
    boolean posterResult = POSTER.postIn(FACEBOOK);
    boolean videoResult = VIDEO.postIn(FACEBOOK);
    assertFalse(noticeResult);
    assertTrue(posterResult);
    assertTrue(videoResult);
  }

  @Test
  public void testScreen() {
    boolean noticeResult = NOTICE.postIn(SCREEN);
    boolean posterResult = POSTER.postIn(SCREEN);
    boolean videoResult = VIDEO.postIn(SCREEN);
    assertFalse(noticeResult);
    assertTrue(posterResult);
    assertFalse(videoResult);  
  }

  @Test
  public void testTelegram() {
    boolean noticeResult = NOTICE.postIn(TELEGRAM);
    boolean posterResult = POSTER.postIn(TELEGRAM);
    boolean videoResult = VIDEO.postIn(TELEGRAM);
    assertTrue(noticeResult);
    assertTrue(posterResult);
    assertFalse(videoResult);
  }

  @Test
  public void testTwitter() {
    boolean noticeResult = NOTICE.postIn(TWITTER);
    boolean posterResult = POSTER.postIn(TWITTER);
    boolean videoResult = VIDEO.postIn(TWITTER);
    assertTrue(noticeResult);
    assertFalse(posterResult);
    assertFalse(videoResult);
  }

  @Test
  public void testUCursos() {
    boolean noticeResult = NOTICE.postIn(UCURSOS);
    boolean posterResult = POSTER.postIn(UCURSOS);
    boolean videoResult = VIDEO.postIn(UCURSOS);
    assertTrue(noticeResult);
    assertFalse(posterResult);
    assertTrue(videoResult);
   }
}
