package platforms;

import api.Cadcc;
import contents.Notice;
import contents.Video;

/**
 * This class represents CaDCC's U-Cursos Community:
 * https://www.u-cursos.cl/uchile/2008/0/COMCADCC/1
 * 
 * @author eriveros
 *
 */
public class UCursos extends AbstractPlatform {

  @Override
  public boolean postVideo(Video video) {
  return Cadcc.PublishInUcursos(video.getTitle(), video.getDescription(), video.getUrl());
  }

  @Override
  public boolean postNotice(Notice notice) {
    return Cadcc.PublishInUcursos(notice.getTitle(), notice.getContent(), null);
  }

  @Override
  protected String getPlatformName() {
    return "U-Cursos";
  }

}
