package platforms;

import api.Cadcc;
import contents.Notice;

/**
 * This class represents CaDCC's Twitter profile: https://www.twitter.com/cadcc
 * 
 * @author eriveros
 *
 */
public class Twitter extends AbstractPlatform {

  @Override
  public boolean postNotice(Notice notice) {
    return Cadcc.PublishInTwitter(notice.getTitle() + ": " + notice.getContent());
  }

  @Override
  protected String getPlatformName() {
    return "Twitter";
  }

}
