package platforms;

import api.Cadcc;
import contents.Notice;
import contents.Poster;

/**
 * This class represents CaDCC's Telegram Channel: https://t.me/cadccInforma
 * 
 * @author eriveros
 *
 */
public class Telegram extends AbstractPlatform {

  @Override
  public boolean postNotice(Notice notice) {
    return Cadcc.PublishInTelegram(notice.getContent(), null);
  }

  @Override
  public boolean postPoster(Poster poster) {
    return Cadcc.PublishInTelegram(poster.getCaption(), poster.getUrl());
  }

  @Override
  protected String getPlatformName() {
    return "Telegram";
  }

}
