package platforms;

import api.Cadcc;
import contents.Poster;
import contents.Video;

/**
 * This class represents CaDCC's Facebook Page: https://www.facebook.com/cadcc.fcfm.
 * 
 * @author eriveros
 *  
 */
public class Facebook extends AbstractPlatform {
  
  public Facebook() {
    this.name = "Facebook";
  }

  @Override
  public boolean postVideo(Video video) {
    return Cadcc.PublishInFacebook(video.getUrl(), video.getDescription());
  }

  @Override
  public boolean postPoster(Poster poster) {
    return Cadcc.PublishInFacebook(poster.getUrl(), poster.getCaption());
  }

}
