package platforms;

import api.Cadcc;
import contents.Notice;
import contents.Poster;
import contents.Video;

/**
 * This class represents CaDCC's Blog: https://www.cadcc.cl
 * 
 * @author eriveros
 *
 */
public class Blog extends AbstractPlatform {

  @Override
  public boolean postVideo(Video video) {
    return Cadcc.PublishInBlog(video.getTitle(), video.getDescription(), video.getUrl());
  }

  @Override
  public boolean postNotice(Notice notice) {
    return Cadcc.PublishInBlog(notice.getTitle(), notice.getContent(), null);
  }

  @Override
  public boolean postPoster(Poster poster) {
    return Cadcc.PublishInBlog("Nuevo Afiche", poster.getCaption(), poster.getUrl());
  }

  @Override
  protected String getPlatformName() {
    return "Blog";
  }


}
