package platforms;

import contents.Notice;
import contents.Poster;
import contents.Video;

public abstract class AbstractPlatform implements IPlatform {
  
  protected String name;

  @Override
  public boolean postVideo(Video video) {
    System.out.println(this.getPlatformName() + " no recibe videos. Saltando publicación en "
        + this.getPlatformName() + "...");
    return false;
  }

  @Override
  public boolean postNotice(Notice notice) {
    System.out.println(this.getPlatformName() + " no recibe avisos. Saltando publicación en "
        + this.getPlatformName() + "...");
    return false;
  }

  @Override
  public boolean postPoster(Poster poster) {
    System.out.println(this.getPlatformName() + " no recibe posters. Saltando publicación en "
        + this.getPlatformName() + "...");
    return false;
  }

  /**
   * Returns the platform name.
   * 
   * @return platform name.
   */
  protected String getPlatformName() {
    return this.name;
  }

}
