package contents;

import platforms.IPlatform;

/**
 * Represents a video (with description and title) for posting in some platforms.
 * @author eriveros
 *
 */
public class Video implements IContent {
  
  private String title, description, url;

  public Video(String title, String description, String videoUrl) {
    this.title = title;
    this.description = description;
    this.url = videoUrl;
  }
  
  /**
   * Returns the title of the video.
   * @return title of video.
   */
  public String getTitle() {
    return this.title;
  }
  
  /**
   * Returns a description of the video.
   * @return description of video.
   */
  public String getDescription() {
    return this.description;
  }
  
  /**
   * Returns the url of the video, uploaded in YouTube.
   * @return url of video.
   */
  public String getUrl() {
    return this.url;
  }

  @Override
  public boolean postIn(IPlatform platform) {
    return platform.postVideo(this);
  }

}
