package contents;

import platforms.IPlatform;

/**
 * Represents a poster (Image and caption) posted in some platforms.
 * @author eriveros
 *
 */
public class Poster implements IContent {
	
	public String url, caption;
	
	/**
	 * Creates a poster object, with a photo and a caption.
	 * @param photo photo url.
	 * @param caption caption of the photo.
	 */
	public Poster(String photoUrl, String caption) {
		this.url = photoUrl;
        this.caption = caption;
	}

	/**
	 * Returns the caption of the poster.
	 * @return caption of poster.
	 */
	public String getCaption() {
		return this.caption;
	}
	
	/** 
	 * Returns poster URL.
	 * @return poster url.
	 */
	public String getUrl() {
	  return this.url;
	}

  @Override
  public boolean postIn(IPlatform platform) {
    return platform.postPoster(this);
  }
}
