package contents;

import platforms.IPlatform;

/**
 * Represents a text notice, with a title and a date, published in some platforms.
 * @author eriveros
 *
 */
public class Notice implements IContent {
	
	private String title, date, content;
	
	/**
	 * Creates a notice with a title, date and text.
	 * @param title The title of the notice.
	 * @param date The date of the notice.
	 * @param content The content of the notice.
	 */
	public Notice(String title, String date, String content) {
		this.title = title;
		this.date = date;
		this.content = content;
	}
	
	/**
	 * Returns the title of the notice.
	 * @return title of notice
	 */
	public String getTitle() {
	  return this.title;
	}
	
	/**
	 * Returns the date of the notice.
	 * @return date of notice
	 */
	public String getDate() {
	  return this.date;
	}
	 
	/**
	 * Returns the content of the notice.
	 * @return content of notice
	 */
	public String getContent() {
	  return this.content;
	}

    @Override
    public boolean postIn(IPlatform platform) {
        return platform.postNotice(this);
    }

}
