package api;

public class Cadcc {

  /**
   * Publishes in cadcc.cl
   * @param title Title of post
   * @param content Content in post.
   * @param photoUrl optional, extra content for post (Example, photo or video).
   * @return true if the message was published and false otherwise.
   */
  public static boolean PublishInBlog(String title, String content, String extraUrl) {
    // Imaginen que acá hay lógica que envía el contenido al blog.
    System.out.println("¡Contenido " + title + " publicado en el blog!");
    return true;
  }

  /**
   * Publishes in twitter.com/cadcc.
   * @param tweet Tweet to publish.
   * @return true if message was published and false otherwise.
   */
  public static boolean PublishInTwitter(String tweet) {
    // Imaginen que acá hay lógica que envía el mensaje a Twitter.
    System.out.println("¡Tweet " + tweet + " publicado!");
    return true;
  }

  /**
   * Publishes media in facebook.com/cadcc.fcfm
   * @param contentUrl URL of content to publish.
   * @param description Description of content to publish.
   * @return true if message was published and false otherwise.
   */
  public static boolean PublishInFacebook(String contentUrl, String description) {
    // Imaginen que acá hay lógica que envía el mensaje a Twitter.
    System.out.println(
        "¡Contenido Audiovisual con descripción " + description + " publicado en Facebook!");
    return true;
  }
  
  /**
   * Publishes in t.me/cadccInforma.
   * @param message message to publish in Telegram.
   * @param photoUrl optional attachment to message.
   * @return true if message was published and false otherwise.
   */
  public static boolean PublishInTelegram(String message, String photoUrl) {
    // Imaginen que acá hay lógica que envía el mensaje a Telegram.
    System.out.println("¡Mensaje " + message + " publicado en Telegram!");
    return true;
  }
  
  /**
   * Publishes in Screen.
   * @param photoUrl url of poster to publish.
   * @return true if message was published and false otherwise.
   */
  public static boolean PublishInScreen(String photoUrl) {
    // Imaginen que acá hay lógica que envía el afiche a la pantalla.
    System.out.println("¡Afiche nuevo publicado en la Pantalla!");
    return true;
  }
  
  /**
   * Publishes in U-Cursos discussion board.
   * @param title Title of post.
   * @param message Message to publish.
   * @param contentUrl URL to extra content.
   * @return true if message was published and false otherwise.
   */
  public static boolean PublishInUcursos(String title, String message, String contentUrl) {
    // Imaginen que acá hay lógica que envía el mensaje a U-Cursos.
    System.out.println("¡Post en el foro titulado  " + title + " publicado en U-Cursos!");
    return true;
  }

}
