package moneyobject;

public class PokemonMoney implements IMoney {
    private double money;
    
    public PokemonMoney(double m){
    	money = m;
    }
    
	@Override
	public double getMoney() {
		return money;
	}

	@Override
	public IMoney addMoney(IMoney mon) {
		return mon.addPokemon(this);	
	}

	@Override
	public DigimonMoney addDigimon(DigimonMoney dmon) {
		return new DigimonMoney(money + dmon.getMoney()*1.41);
		
	}

	@Override
	public PokemonMoney addPokemon(PokemonMoney pmon) {
		return new PokemonMoney(money + pmon.getMoney());
		
	}


}
