package moneyobject;

public class DigimonMoney implements IMoney {
    private double money;
    
    public DigimonMoney(double m){
    	money = m;
    }
    
	@Override
	public double getMoney() {
		return money;
	}

	@Override
	public IMoney addMoney(IMoney mon) {
		return mon.addDigimon(this);
	}

	@Override
	public DigimonMoney addDigimon(DigimonMoney dmon) {
		return new DigimonMoney(money + dmon.getMoney());
	}

	@Override
	public PokemonMoney addPokemon(PokemonMoney pmon) {
		return new PokemonMoney(money + pmon.getMoney()/2.25);
	}

}
