# -*- coding: utf-8 -*-

# clase Polera
class Polera:
    # Constructor: self, string, string -> Polera
    # Inicializa un objeto polera
    def __init__(self, color, talla):
        assert talla in ["S", "M", "L"]
        assert color in ["rojo", "verde", "azul"]
        self.__color = color
        self.__talla = talla

    # getColor: self -> string
    def getColor(self):
        return self.__color

    # getTalla: self -> string
    def getTalla(self):
        return self.__talla

    # setColor: self, string -> None
    def setColor(self, color):
        self.__color = color

    # setTalla: self, string -> None
    def setTalla(self, talla):
        self.__talla = talla

polerasRojas = {"S": 5, "M": 3, "L": 12}
polerasVerdes = {"S": 6, "M": 15, "L": 1}
polerasAzules = {"S": 2, "M": 7, "L": 5}

inventario = {"rojo": polerasRojas,
                "verde": polerasVerdes,
                "azul": polerasAzules}


# agregarPolera: Polera, dict[dict] -> None
def agregarPolera(polera, inventario):
    color = polera.getColor()
    talla = polera.getTalla()
    inventario[color][talla] += 1

# poleraAzul = Polera("azul", "M")
# agregarPolera(poleraAzul, inventario)
# assert inventario["azul"]["M"] == 8
# agregarPolera(poleraAzul, inventario)
# assert inventario["azul"]["M"] == 9

# borrarPolera: Polera, dict[dict] -> None
def borrarPolera(polera, inventario):
    color = polera.getColor()
    talla = polera.getTalla()
    if inventario[color][talla] > 0:
        inventario[color][talla] -= 1

# for i in range(8):
#     borrarPolera(poleraAzul, inventario)

# assert inventario["azul"]["M"] == 1
# borrarPolera(poleraAzul, inventario)
# assert inventario["azul"]["M"] == 0
# borrarPolera(poleraAzul, inventario)
# assert inventario["azul"]["M"] == 0

def contar(inventario):
    total = 0
    for color in inventario:
        dictActual = inventario[color]
        for talla in dictActual:
            total += inventario[color][talla]
    return total

assert contar(inventario) == 56
