def eliminarRepetidos(lista):
	listaNueva = []
	for elemento in lista:
		if elemento not in listaNueva:
			listaNueva.append(elemento)
	return listaNueva

def eliminarElemento(lista, elementoAEliminar):
	listaNueva = []
	for elemento in lista:
		if elemento != elementoAEliminar:
			listaNueva.append(elemento)
	return listaNueva

assert eliminarRepetidos([1,2,3,4,2,8,1,3,2]) == [1,2,3,4,8]

# Clase Conjunto
# self.lista (list[string])
class Conjunto:
	# constructor
	def __init__(self, listaInicial):
		self.lista = eliminarRepetidos(listaInicial)

	# tiene: self, string -> bool
	# Retorna True si es que la fruta esta en la canasta,
	# False en caso contrario
	def tiene(self, nombreFruta):
		return nombreFruta in self.lista

	# agregar: self, string -> bool
	# Si es que la fruta no esta en la canasta, la agrega y retorna
	# True. En caso contrario, no la agrega y retorna False
	def agregar(self, nombreFruta):
		if not self.tiene(nombreFruta):
			self.lista.append(nombreFruta)
			return True
		return False

	# sacar: self, string -> none
	# Elimina nombreFruta de lista (si es que existe)
	def sacar(self, nombreFruta):
		if self.tiene(nombreFruta):
			self.lista.remove(nombreFruta)

	def getLista(self):
		return self.lista

	def setLista(self, otraLista):
		self.lista = eliminarRepetidos(otraLista)

	# union: self, Conjunto -> Conjunto
	def union(self, otroConjunto):
		otraLista = otroConjunto.getLista()
		listaTotal = self.lista + otraLista # pueden haber repetidos
		return Conjunto(listaTotal)

	# interseccion: self, Conjunto -> Conjunto
	def interseccion(self, otroConjunto):
		nuevaLista = []
		listaOtro = otroConjunto.getLista()
		for elemento in self.lista:
			if elemento in listaOtro:
				nuevaLista.append(elemento)

		return Conjunto(nuevaLista)

	# resta: self, Conjunto -> Conjunto
	def resta(self, otroConjunto):
		nuevaLista = []
		otraLista = otroConjunto.getLista()
		for elemento in self.lista:
			if elemento not in otraLista:
				nuevaLista.append(elemento)
		return Conjunto(nuevaLista)


listaInicial = ["manzana", "pera", "chirimoya", "guayaba", "granada"]
conjunto1 = Conjunto(listaInicial)

assert conjunto1.tiene("manzana")
assert conjunto1.tiene("granada")
assert not conjunto1.tiene("mandarina")

assert conjunto1.agregar("naranja")
assert not conjunto1.agregar("manzana")

assert conjunto1.tiene("naranja")
assert conjunto1.tiene("manzana")

conjunto1.sacar("manzana")
conjunto1.sacar("chirimoya")

assert not conjunto1.tiene("manzana")
assert not conjunto1.tiene("chirimoya")

assert conjunto1.getLista() == ["pera", "guayaba", "granada", "naranja"]
 
conjunto2 = Conjunto(["manzana", "pera", "chirimoya", "guayaba"])

union = conjunto1.union(conjunto2)
assert union.getLista() == ["pera", "guayaba", "granada", "naranja", "manzana", "chirimoya"]

interseccion = conjunto1.interseccion(conjunto2)
assert interseccion.getLista() == ["pera", "guayaba"]

resta1 = conjunto1.resta(conjunto2)
assert resta1.getLista() == ["granada", "naranja"]

resta2 = conjunto2.resta(conjunto1)
assert resta2.getLista() == ["manzana", "chirimoya"]
