# actualizarTiempo: diccionario -> diccionario
def actualizarTiempo(dns):
	dnsNuevo = {}
	for llave in dns:
		valor = dns[llave]
		tiempo = valor[0]
		ip = valor[1]
		if tiempo > 1:
			dnsNuevo[llave] = [tiempo - 1, ip]
	return dnsNuevo

dns = {"www.google.com": [10, "8.8.8.8"],
		"www.twitter.com": [7, "1.1.1.1"],
		"www.debateanatel.cl": [0, "123.123"]}

assert actualizarTiempo(dns) == {"www.google.com": [9, "8.8.8.8"],
								"www.twitter.com": [6, "1.1.1.1"]}

import random

# agregarConsulta: dict[string -> list[int, string]], string, string -> dict
def agregarConsulta(dns,dominio,ip):
	numeroAleatorio = random.randint(10,100)
	dns[dominio] = [numeroAleatorio,ip]
	return dns

for i in range(200):
	dnsNuevo = agregarConsulta(dns, "www.graficosfeos.cl", "30.22.27")
	tiempo = dnsNuevo["www.graficosfeos.cl"][0]
	assert tiempo >= 10
	assert tiempo <= 100

# consultar: dict, string -> list[int, string]
def consultar(dns, nombre):
	if nombre in dns:
		return dns[nombre]
	return [-1,"-1"]

assert consultar(dns, "www.google.com") == [10, "8.8.8.8"]
assert consultar(dns, "www.netflixgratis.com") == [-1, "-1"]



