# -*- coding: utf-8 -*-
import estructura
from lista import *

# Persona: nombre (string), estatura(float), hijos (lista(Persona))
estructura.crear("Persona", "nombre estatura hijos")

p1 = Persona("Valeria", 1.58, None)
p2 = Persona("Colomba", 0.65, None)
p3 = Persona("Evelyn", 1.75, lista(p2, None))
p4 = Persona("Daniela", 1.65, None)
p5 = Persona("Wilson", 1.70, lista(p4, lista(p1, lista(p3, None))))

personaExtra = Persona("Juanjo", 1.75, None)
# crearPersona: str, float, lista(Persona) -> Persona
# Crea un objeto del tipo Persona
# Ejemplo: crearPersona("Juanjo", 1.75, None)-> Persona("Juanjo", 1.75, None)
def crearPersona(nombre, estatura, listaHijos):
    return Persona(nombre, estatura, listaHijos)

assert crearPersona("Juanjo", 1.75, None) == personaExtra

# agregarPersona: lista(Persona), Persona -> lista(Persona)
# Agrega una persona al principio de una lista
# Ejemplo:
def agregarPersona(L, persona):
    return lista(persona, L)

assert agregarPersona(p5.hijos, personaExtra) == lista(personaExtra, \
                                                       lista(p4, lista(p1, lista(p3, None))))

# tenerHijo: Persona, string, float, lista(Persona) -> Persona
# Agrega una nueva persona a la lista de hijos de P
# Ejemplo: tenerHijo(p5, "Juanjo", 1.75, None) -> Persona("Wilson", 1.70, lista(personaExtra, lista(p5, lista(p1, lista(p3, None)))))
def tenerHijo(p, nombreNuevo, estaturaNueva, hijosNuevo):
    # creamos al hijo/a
    nueva = crearPersona(nombreNuevo, estaturaNueva, hijosNuevo)
    # creamos una lista con todos los hijos
    nuevaListaHijos = agregarPersona(p.hijos, nueva)
    # clonamos el padre/madre
    clon = crearPersona(p.nombre, p.estatura, nuevaListaHijos)
    return clon
assert tenerHijo(p5, "Juanjo", 1.75, None) == Persona("Wilson", 1.70, \
                                                    lista(personaExtra, \
                                                          lista(p4, \
                                                                lista(p1, \
                                                                      lista(p3, None)))))



# personaMasAlta_Aux: lista(Persona) -> Persona
# Dada una lista de personas, y un maxActual, retorna la persona más alta de la lista
# Ejemplo: personaMasAlta_Aux(p5.hijos, personaExtra) -> personaExtra
def personaMasAlta_Lista(L, maxActual):
    if L == None:
        return maxActual
    else:
        masAlto = personaMasAlta(cabeza(L))
        if masAlto.estatura > maxActual.estatura:
            maxActual = masAlto
        return personaMasAlta_Lista(cola(L), maxActual)




# personaMasAlta: Persona -> Persona
# Recorre un árbol genealógico buscando a la persona más alta
# Ejemplo: personaMasAlta(p5) -> p3
def personaMasAlta(p):
    if p == None:
        return None
    else:
        maxActual = Persona("", 0, None)
        hijoMasAlto = personaMasAlta_Lista(p.hijos, maxActual)
        if hijoMasAlto.estatura > p.estatura:
            return hijoMasAlto
        else:
            return p

assert personaMasAlta_Lista(p5.hijos, personaExtra) == personaExtra
assert personaMasAlta(p5) == p3








