# -*- coding: utf-8 -*-
import estructura
estructura.crear("nodo", "valor izq der")

arbol1 = nodo(1,
            nodo(2,
                 nodo(4,
                      nodo(7, None, None), None),
                 nodo(5, None, None)),
            nodo(3,
                 nodo(6, None, None), None))

arbol2 = nodo(1,
            nodo(2,
                 nodo(4,
                      nodo(7, None, None), None),
                 None),
            nodo(3,
                 nodo(6, None, None), None))

arbol3 = nodo(1,
            nodo(2,
                 nodo(4,
                      nodo(7, None, None), None),
                 nodo(5, None, None)),
            nodo(3, None, None))

# tamano: nodo -> int
# Calcula la cantidad de nodos en un arbol
# Ejemplo: tamano(arbol1) -> 7
def tamano(arbol):
    if arbol == None:
        return 0
    else:
        return 1 + tamano(arbol.izq) + tamano(arbol.der)

assert tamano(arbol1) == 7

# altura: nodo -> int
# Calcula la altura del árbol
# Ejemplo: atura(arbol1) -> 4
def altura(arbol):
    if arbol == None:
        return 0
    else:
        return 1 + max(altura(arbol.izq), altura(arbol.der))
assert altura(arbol1) == 4

# esBalanceado: nodo -> booleano
# Retorna True si un árbol es balanceado, False en caso contrario
# Ejemplo: esBalanceado(arbol1) -> True
def esBalanceado(arbol):
    if arbol == None:
        return True
    alturaIzq = altura(arbol.izq)
    alturaDer = altura(arbol.der)
    if abs(alturaIzq - alturaDer) > 1:
        return False
    else:
        return esBalanceado(arbol.izq) and esBalanceado(arbol.der)

assert esBalanceado(arbol1)
assert not esBalanceado(arbol2)
assert not esBalanceado(arbol3)










