# -*- coding: utf-8 -*-
import estructura
from lista import *
from P1 import ordenar

# Pais: nombre (string), puntos (int)
estructura.crear("Pais", "nombre puntos")

# Tabla ordenada alfabéticamente
tablaAbc = lista(Pais("Argentina", 24),
            lista(Pais("Bolivia", 13),
            lista(Pais("Brasil", 37),
            lista(Pais("Chile", 23),
            lista(Pais("Colombia", 26),
            lista(Pais("Ecuador", 20),
            lista(Pais("Paraguay", 21),
            lista(Pais("Perú", 24),
            lista(Pais("Uruguay", 27,),
            lista(Pais("Venezuela", 8),None))))))))))

# Tabla ordenada por puntos, sin crear una nueva función y sólo usando lambda :D
tablaPuntos = ordenar(tablaAbc, lambda x, y : x.puntos > y.puntos)
#print tablaPuntos


# PartidoChile: pais (string), estadio (string), fecha (string)
estructura.crear("PartidoChile", "pais estadio fecha")

# Lista de próximos partidos de Chile
# Disclaimer: la lista puede no corresponder a la realidad :c
proximos = lista(PartidoChile("Ecuador", "Nacional", "05/10/2017"),
                lista(PartidoChile("Brasil", "Maracaná", "10/10/2017"),
                lista(PartidoChile("Argentina", "Bombonera", "18/02/2018"),
                lista(PartidoChile("Perú", "Monumental", "16/10/2019"),
                lista(PartidoChile("España", "Camp Nou", "15/12/2020"),
                lista(PartidoChile("Alemania", "Sausalito", "30/02/2025"),
                lista(PartidoChile("Inglaterra", "Nacional", "21/05/2027"),
                lista(PartidoChile("Francia", "Stade de France", "31/06/2030"), None))))))))


# Lista de estadios donde Chile juega de local (i.e, estadios chilenos)
estadiosChile = lista("Monumental", lista("Nacional", lista("Sausalito", None)))

# estaEn: lista(any), any -> boolean
# Retorna True si valor está en L, False en caso contrario
# Ejemplo: estaEn(estadiosChile, "Nacional") -> True
def estaEn(L, valor):
    if vacia(L):
        return False
    if cabeza(L) == valor:
        return True
    return estaEn(cola(L), valor)

assert estaEn(estadiosChile, "Nacional")
assert not estaEn(estadiosChile, "Bombonera")


# partidosLocal: lista(PartidoChile), lista(str) -> lista(PartidoChile)
# Retorna la lista de partidos de Chile que se jugarán en estadios chilenos,
# es decir, en aquellos estadios ingresados en listaEstadios
# Ejemplo: partidosLocal(proximos, estadiosChile) -> lista(PartidoChile('Ecuador', 'Nacional', '05/10/2017'), lista(PartidoChile('Perú', 'Monumental', '16/10/2019'), lista(PartidoChile('Alemania', 'Sausalito', '30/02/2025'), lista(PartidoChile('Inglaterra', 'Nacional', '21/05/2027'), None))))
def partidosLocal(listaPartidos, listaEstadios):
    if vacia(listaPartidos):
        return None
    else:
        partidoActual = cabeza(listaPartidos)
        if estaEn(listaEstadios, partidoActual.estadio):
            return lista(partidoActual,
                partidosLocal(cola(listaPartidos), listaEstadios))
        else:
            return partidosLocal(cola(listaPartidos), listaEstadios)

assert partidosLocal(proximos, estadiosChile) == lista(PartidoChile('Ecuador', 'Nacional', '05/10/2017'), lista(PartidoChile('Perú', 'Monumental', '16/10/2019'), lista(PartidoChile('Alemania', 'Sausalito', '30/02/2025'), lista(PartidoChile('Inglaterra', 'Nacional', '21/05/2027'), None))))
