# -*- coding: utf-8 -*-
from lista import *

L = lista(3, lista(5, lista(12, lista(4, lista(5, None)))))

# maximo: lista(int) int -> int
# Retorna el máximo de una lista de enteros
# Para que funcione bien, el valor maxActual ingresado al principio debe ser menor
# a todos los elementos de la lista.
# Ejemplo: maximo(L, 0) -> 12
def maximo(L, maxActual):
    if vacia(L):
        return maxActual
    else:
        if cabeza(L) > maxActual:
            maxActual = cabeza(L)
        return maximo(cola(L), maxActual)


assert maximo(L, 0) == 12
assert maximo(L, 15) == 15

# sacarElemento: lista(int) int -> lista(int)
# sacar un eleento de una lista (sólo la primera aparición)
# Ejemplo: sacarElemento(L, 5) -> lista(3, lista(12, lista(4, lista(5, None))))
def sacarElemento(L, valor):
    if vacia(L):
        return None
    else:
        if cabeza(L) == valor:
            # sacarlo de la lista
            return cola(L)
        else:
            # mantener elemento en la lista
            return crearLista(cabeza(L),
                              sacarElemento(cola(L), valor))


assert sacarElemento(L, 5) == lista(3, lista(12, lista(4, lista(5, None))))
assert sacarElemento(L, 3) == lista(5, lista(12, lista(4, lista(5, None))))
assert sacarElemento(L, 21) == L

# ordenarMayorAMenor: lista(int) -> lista(int)
# Ordena una lista de enteros decrecientemente
# Ejemplo: ordenarMayorAMenor(L) -> lista(12, lista(5, lista(5, lista(4, lista(3, None)))))
def ordenarMayorAMenor(L):
    if vacia(L):
        return None
    else:
        maxActual = maximo(L, cabeza(L))
        listaLimpia = sacarElemento(L, maxActual)
        return lista(maxActual,
                     ordenarMayorAMenor(listaLimpia))

assert ordenarMayorAMenor(L) == lista(12, lista(5, lista(5, lista(4, lista(3, None)))))

# extraerPrimero: lista(int), int, <f(int, int) -> boolean> -> int
# Retorna el elemento de la lista que cumpla con fComp.
# De esta forma, si fComp es una función x, y: x > y; extraerPrimero retornará el máximo de L
# Por otro lado, si fComp es una función x, y: x < y; extraerPrimero retornará el mínimo de L
# Ejemplo: extraerPrimero(L, 0, lambda x, y: x > y) -> maximo(L, 0)
def extraerPrimero(L, valorActual, fComp):
    if vacia(L):
        return valorActual
    else:
        if fComp(cabeza(L), valorActual):
            valorActual = cabeza(L)
        return extraerPrimero(cola(L), valorActual, fComp)

assert extraerPrimero(L, 0, lambda x, y: x > y) == maximo(L, 0)
assert extraerPrimero(L, 9999, lambda x, y: x < y) == 3

# ordenar: lista(int) <f(int int) -> boolean> -> lista(int)
# Retorna una lista ordenada de acuerdo al criterio establecido por fCompo
# Ejemplo: ordenar(L, lambda x, y: x > y) -> lista(12, lista(5, lista(5, lista(4, lista(3, None)))))
def ordenar(L, fComp):
    if vacia(L):
        return None
    else:
        valorActual = extraerPrimero(L, cabeza(L), fComp)
        listaLimpia = sacarElemento(L, valorActual)
        return lista(valorActual,
                     ordenar(listaLimpia, fComp))


assert ordenar(L, lambda x, y: x > y) == lista(12, lista(5, lista(5, lista(4, lista(3, None)))))
assert ordenar(L, lambda x, y: x < y) == lista(3, lista(4, lista(5, lista(5, lista(12, None)))))



