# -*- coding: utf-8 -*-
import estructura

# Persona: nombre (str), sexo (str), entrada (int)
estructura.crear("Persona", "nombre sexo entrada")

# puedeParticipar: Persona, int -> bool
# Verifica si es que una persona p puede participar; tiene que haber entrado hace menos de 3 años
# Ejemplo: puedeParticipar(Persona("Catalina", "M", 2017), 2017) -> True
def puedeParticipar(p, anioActual):
    return anioActual - p.entrada <= 3

p1 = Persona("Juan", "H", 2017)
p2 = Persona("Catalina", "M", 2017)
p3 = Persona("Juanjo", "H", 2011)

assert puedeParticipar(p1, 2017)
assert puedeParticipar(p2, 2016)
assert not puedeParticipar(p3, 2017)


# dialogo: int int int -> None
# Diálogo interactivo; pregunta al usuario por datos personales y verifica si es que
# puede participar en la feria de programación (partyhard). Además, guarda la
# cantidad de hombres y mujeres que están participando hasta el momento.
def dialogo(anioActual, totalMujeres, totalHombres):
    nombre = raw_input("Nombre? ")

    if nombre == "FIN":
        print "Hay " + str(totalMujeres + totalHombres) + "inscritos este año " + str(anioActual)
        print "Niñas: " + str(totalMujeres) + ", Niños: " + str(totalHombres)
        return

    sexo = raw_input("Sexo ?")
    anioIngreso = input("Año de ingreso a la UCH? ")
    p = Persona(nombre, sexo, anioIngreso)

    if puedeParticipar(p, anioActual):
        if p.sexo == "M":
            print "Bienvenida " + p.nombre
            totalMujeres += 1
        elif p.sexo == "H":
            print "Bienvenido " + p.nombre
            totalHombres += 1
    else:
        print "Lo sentimos " + p.nombre + ", eres demasiado vieja/o :("

    dialogo(anioActual, totalMujeres, totalHombres)

anioActual = input("Año actual? ")
dialogo(anioActual, 0, 0)
