# -*- coding: utf-8 -*-
import estructura

# Tiempo: horas  (int), minutos (int)
estructura.crear("Tiempo", "horas minutos")

# crearTiempo: int int -> Tiempo
# Crea un tiempo "correcto", con menos de 60 minutos
# Ejemplo: crearTiempo(0, 75) -> Tiempo(1, 15)
def crearTiempo(horas, minutos):
    minutosCorrectos = minutos % 60
    horasCorrectas = horas + minutos / 60
    return Tiempo(horasCorrectas, minutosCorrectos)

assert crearTiempo(0, 75) == Tiempo(1, 15)
assert crearTiempo(3, 130) == Tiempo(5, 10)

# auxiliarString: int -> string
# Retorna un número en formato XX (si es menor a 10, antepone un 0)
# Ejemplo: auxiliarString(5) -> "05"
def auxiliarString(n):
    if n < 10:
        return "0" + str(n)
    else:
        return str(n)

assert auxiliarString(7) == "07"
assert auxiliarString(99) == "99"

# aString: Tiempo -> string
# Pasa un tiempo a formato HHMM (asumiremos que horas es menor a 24)
# Ejemplo: aString(Tiempo(15, 20)) == "15:20"
def aString(tiempo):
    return auxiliarString(tiempo.horas) + ":" + \
            auxiliarString(tiempo.minutos)

assert aString(Tiempo(1, 15)) == "01:15"
assert aString(Tiempo(15, 20)) == "15:20"
assert aString(Tiempo(18, 90)) == "18:90"
# En el último assert, fíjense que Tiempo no es un tiempo correcto, pero igual funciona. ¿Por qué?


# enMinutos: Tiempo -> int
# Retorna la cantidad total de minutos en un objeto de tipo Tiempo
# Ejemplo: enMinutos(Tiempo(1, 15)) -> 75
def enMinutos(t):
    return t.horas * 60 + t.minutos

assert enMinutos(Tiempo(1, 15)) == 75
miTiempo = Tiempo(15, 12) # se pueden crear variables para testear
assert enMinutos(miTiempo) == 15*60 + 12

# Las dos líneas siguientes tiran error. Asegúrese de entender el motivo.
# assert enMinutos(20, 17) == 20*60 + 17
# assert enMinutos("20:17") == 20*60 + 17

# comparar: Tiempo, Tiempo -> int
# Compara dos Tiempos (t1 y t2), y entrega 1 si t1 es mayor, -1 si t2 es mayor
# 0 si son iguales
# Ejemplo: comparar(Tiempo(1, 15), Tiempo(1, 14)) == 1
def comparar(t1, t2):
    minutosT1 = enMinutos(t1)
    minutosT2 = enMinutos(t2)
    if minutosT1 > minutosT2:
        return 1
    elif minutosT1 == minutosT2:
        return 0
    else:
        return -1


assert comparar(Tiempo(1, 15), Tiempo(1, 14)) == 1
assert comparar(Tiempo(2, 20), Tiempo(2, 55)) == -1
assert comparar(Tiempo(3, 30), Tiempo(3, 30)) == 0


# diferencia: Tiempo Tiempo -> Tiempo
# Calcula la diferencia entre dos tiempos, y retorna un Tiempo "correcto"
# Ejemplo: diferencia(Tiempo(12, 15), Tiempo(10, 45)) -> Tiempo(1, 30)
def diferencia(t1, t2):
    minutosT1 = enMinutos(t1)
    minutosT2 = enMinutos(t2)
    diferenciaAbsoluta = abs(minutosT1 - minutosT2)
    return crearTiempo(0, diferenciaAbsoluta)

assert diferencia(Tiempo(12, 15), Tiempo(10, 45)) == Tiempo(1, 30)
assert diferencia(Tiempo(17, 45), Tiempo(16, 30)) == Tiempo(1, 15)




















