# -*- coding: utf-8 -*-
import math

# cerca: num num num -> boolean
# Retorna True si la diferencia entre x e y es menor a epsilon,False en caso contrario
def cerca(x, y, epsilon):
    return abs(x - y) < epsilon

assert cerca(1, 0.999, 0.01)
assert not cerca(1, 0.9, 0.01)

# exp: num int num -> num
# Calcula recursivamente la función exponencial de x, hasta que la diferencia entre dos iteraciones sea menor a epsilon
def exp(x, k, epsilon):
    # la diferencia entre dos iteraciones en este caso corresponde al último término
    # de la sumatoria
    current = 1.0*x**k / math.factorial(k)
    # el abs es para que funcione con x negativo
    if abs(current) < epsilon:
        return 0
    else:
        return current + exp(x, k + 1, epsilon)


epsilon = 0.000001
assert cerca(exp(3, 0, epsilon), math.exp(3), epsilon)
assert cerca(exp(10, 0, epsilon), math.exp(10), epsilon)
assert cerca(exp(-1, 0, epsilon), math.exp(-1), epsilon)
