# -*- coding: utf-8 -*-

################################## PREGUNTA 1 ##################################

# invertir3: int -> int
# Invierte un número de tres dígitos
# Ejemplo: invertir3(123) = 321
def invertir3(n):
    u = n % 10
    d = (n / 10) % 10
    c = n / 100
    return u * 100 + d * 10 + c

assert invertir3(123) == 321
assert invertir3(876) == 678
assert invertir3(102) == 201
assert invertir3(120) == 21
assert invertir3(900) == 9


# invertir4_a: int -> int
# Invierte un número de cuatro dígitos
# Ejemplo: invertir4_a(1234) = 4321
def invertir4_a(n):
    u = n % 10
    d = (n / 10) % 10
    c = (n / 100) % 10
    m = n / 1000
    return u * 1000 + d * 100 + c * 10 + m

assert invertir4_a(1234) == 4321
assert invertir4_a(8765) == 5678
assert invertir4_a(1023) == 3201
assert invertir4_a(1200) == 21
assert invertir4_a(9000) == 9


# invertir4_b: int -> int
# Invierte un número de cuatro dígitos, utilizando la función invertir3
# Ejemplo: invertir4_b(1234) = 4321
def invertir4_b(n):
    u = n % 10
    tresPrimerosInvertidos = invertir3(n / 10)
    return u * 1000 + tresPrimerosInvertidos

assert invertir4_b(1234) == 4321
assert invertir4_b(8765) == 5678
assert invertir4_b(1023) == 3201
assert invertir4_b(1200) == 21
assert invertir4_b(9000) == 9

################################## PREGUNTA 2 ##################################

# hhmmAMinutos: int -> int
# Transforma un número en formato HHMM a cantidad de minutos totales
# Ejemplo: hhmmAMinutos(932) = 9 * 60 + 32 = 532
def hhmmAMinutos(n):
    horas = n / 100
    minutos = n % 100
    return horas * 60 + minutos
assert hhmmAMinutos(932) == 9 * 60 + 32
assert hhmmAMinutos(1956) == 19 * 60 + 56
assert hhmmAMinutos(3) == 3  # 0003


# minutosAHhmm: int -> int
# Transforma un total de minutos a formato HHMM
# Ejemplo: minutosAHhmm(740) = 1220
def minutosAHhmm(totalMinutos):
    horas = totalMinutos / 60
    minutos = totalMinutos % 60
    return horas * 100 + minutos

assert minutosAHhmm(60) == 100
assert minutosAHhmm(59) == 59
assert minutosAHhmm(740) == 1220
assert minutosAHhmm(1196) == 1956


# diferenciaInstantes: int int -> int
# Calcula la diferenca entre dos instantes en formato HHMM
# Ejemplo: diferenciaInstantes(1932, 816) = 1116
def diferenciaInstantes(instante1, instante2):
    minutos1 = hhmmAMinutos(instante1)
    minutos2 = hhmmAMinutos(instante2)
    mayor = max(minutos1, minutos2)
    menor = min(minutos1, minutos2)
    dif = mayor - menor
    return minutosAHhmm(dif)

assert diferenciaInstantes(1932, 816) == 1116
assert diferenciaInstantes(816, 1932) == 1116
assert diferenciaInstantes(520, 340) == 140

################################## PREGUNTA 3 ##################################

# billetes20k : int -> int
# Retorna la cantidad máxima de billetes de 20000 que puedes tener
# dada esa cantidad de dinero
# Ejemplo: billetes20k(95000) -> 4
def billetes20k(dinero):
    return dinero / 20000

assert billetes20k(95000) == 4
assert billetes20k(20000) == 1
assert billetes20k(19999) == 0


# billetes10k : int -> int
# Retorna la cantidad máxima de billetes de 10000 que puedes tener
# dada esa cantidad de dinero
# Ejemplo: billetes10k(95000) -> 4
def billetes10k(dinero):
    return dinero / 10000

assert billetes10k(95000) == 9
assert billetes10k(10000) == 1
assert billetes20k(9999) == 0


# nBilletes: int int -> int
# Dada una cantidad de dinero y un valor de billetes, retorna cuántos billetes
# de dicha nominación "caben" en esa cantidad
# Ejemplo: nBilletes(11000, 5000) -> 2
def nBilletes(cantidadDinero, valorBillete):
    return cantidadDinero / valorBillete

assert nBilletes(95000, 20000) == 4
assert nBilletes(95000, 10000) == 9
assert nBilletes(9999, 20000) == 0


# organizarDinero: int -> none
# Imprime en pantalla la menor cantidad de billetes necesarios para tener esa cantidad,
# junto a la nominación correspondiente
def organizarDinero(cantidadDinero):
    b20k = nBilletes(cantidadDinero, 20000)
    cantidadDinero -= 20000 * b20k
    b10k = nBilletes(cantidadDinero, 10000)
    cantidadDinero -= 10000 * b10k
    b5k = nBilletes(cantidadDinero, 5000)
    cantidadDinero -= 5000 * b5k
    b2k = nBilletes(cantidadDinero, 2000)
    cantidadDinero -= 2000 * b2k
    b1k = nBilletes(cantidadDinero, 1000)
    cantidadDinero -= 1000 * b1k

    print str(b20k) + " billetes de 20000"
    print str(b10k) + " billetes de 10000"
    print str(b5k) + " billetes de 5000"
    print str(b2k) + " billetes de 2000"
    print str(b1k) + " billetes de 1000"

organizarDinero(98000)
