#/!usr/bin/env python

import requests
from bs4 import BeautifulSoup
import time
from urlparse import urljoin

response = requests.get("https://www.rottentomatoes.com/browse/in-theaters/")

soup = BeautifulSoup(response.text, "lxml")

sub_soup = soup.select(".mb-movie") 

links = []
for sub in sub_soup:
	links.append(urljoin("https://www.rottentomatoes.com", sub.select("a")[0].attrs["href"]))

print links

for link in links[:]:
	print "Crawling %s" % link
	response = requests.get(link)
	soup = BeautifulSoup(response.text, "lxml")
	movie_title = soup.select("h1")[0].text.strip()
	movie_synopsis = soup.select("#movieSynopsis")[0].text.strip()
	with open("data/" + movie_title, "w") as out_file:
		out_file.write(movie_synopsis.encode("utf-8"))
	time.sleep(5)
