/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ws;

import edu.csus.ecs.pc2.api.IContest;
import edu.csus.ecs.pc2.api.ServerConnection;
import edu.csus.ecs.pc2.api.implementation.APIPlugin;
import java.util.Map;

public class ResponseHandler
implements APIPlugin {
    private static final String START_CLOCK_PATH = "/ccs/start_clock";
    private static final String STOP_CLOCK_PATH = "/ccs/stop_clock";
    private static final String SET_CLOCK_PATH = "/starttime";
    private static final String GET_CLOCK_START_TIME_PATH = "/ccs/contest_starttime";
    private static final String CLOCK_STARTED_PATH = "/ccs/contest_started";
    private String startTime = "undefined";
    private IContest contest;
    private ServerConnection serverConnection;

    public String getResponse(String path, Map<String, String> parameters) throws Exception {
        if (path == null) {
            return this.get404Response(path);
        }
        if (START_CLOCK_PATH.equals(path)) {
            this.serverConnection.startContestClock();
            return this.tag("pre", "Started Contest");
        }
        if (STOP_CLOCK_PATH.equals(path)) {
            this.serverConnection.stopContestClock();
            return this.tag("pre", "Stopped/Paused Contest");
        }
        if (GET_CLOCK_START_TIME_PATH.equals(path)) {
            return this.tag("start_time", this.startTime);
        }
        if (SET_CLOCK_PATH.equals(path)) {
            return this.setStartTime(this.getAbsoluteParameter(parameters));
        }
        if (CLOCK_STARTED_PATH.equals(path)) {
            return this.tag("contest_started", "" + this.contest.isContestClockRunning());
        }
        return this.get404Response(path);
    }

    private String tag(String name, String value) {
        return "<" + name + ">" + value + "</" + name + ">";
    }

    private String setStartTime(String newTime) {
        this.startTime = newTime;
        return this.tag("start_time", this.startTime);
    }

    private String getAbsoluteParameter(Map<String, String> parameters) {
        String value = parameters.get("absolute");
        if (value == null) {
            value = "";
        }
        return value;
    }

    private String get404Response(String path) {
        return this.tag("center", "404 error - no page found \"" + path + "\"");
    }

    @Override
    public String getPluginTitle() {
        return "RequestHandler";
    }

    @Override
    public void setContestAndServerConnection(ServerConnection inServerConnection, IContest inContest) {
        this.serverConnection = inServerConnection;
        this.contest = inContest;
    }
}

