/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui.eventfeed;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.IniFile;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.ContestTimeEvent;
import edu.csus.ecs.pc2.core.model.IContestTimeListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.ui.ContestClockDisplay;
import edu.csus.ecs.pc2.ui.EventFeedServerPane;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.OptionsPane;
import edu.csus.ecs.pc2.ui.PacketMonitorPane;
import edu.csus.ecs.pc2.ui.PluginLoadPane;
import edu.csus.ecs.pc2.ui.UIPlugin;
import edu.csus.ecs.pc2.ui.WebServerPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class ServicesView
extends JFrame
implements UIPlugin {
    private static final long serialVersionUID = 2157337344457051296L;
    private IInternalContest contest;
    private IInternalController controller;
    private JTabbedPane mainTabbedPane = null;
    private Log log;
    private JPanel mainViewPane = null;
    private JPanel northPane = null;
    private JLabel clockLabel = null;
    private JLabel messageLabel = null;
    private JPanel eastPane = null;
    private JButton exitButton = null;
    private ContestClockDisplay contestClockDisplay = null;
    private JPanel clockPanel = null;

    public ServicesView() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(515, 319));
        this.setContentPane(this.getMainViewPane());
        this.setDefaultCloseOperation(0);
        this.setTitle("Services");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ServicesView.this.promptAndExit();
            }
        });
        this.overRideLookAndFeel();
        FrameUtilities.centerFrame(this);
    }

    private void overRideLookAndFeel() {
        String value = IniFile.getValue("client.plaf");
        if (value != null && value.equalsIgnoreCase("java")) {
            FrameUtilities.setJavaLookAndFeel();
        }
        if (value != null && value.equalsIgnoreCase("native")) {
            FrameUtilities.setNativeLookAndFeel();
        }
    }

    protected void promptAndExit() {
        int result = FrameUtilities.yesNoCancelDialog(null, "Are you sure you want to exit PC^2?", "Exit PC^2");
        if (result == 0) {
            System.exit(0);
        }
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.contest.addContestTimeListener(new ContestTimeListenerImplementation());
        this.log = this.controller.getLog();
        this.log.info("Started Services View");
        this.contestClockDisplay = new ContestClockDisplay(this.controller.getLog(), this.contest.getContestTime(), this.contest.getSiteNumber(), true, null);
        this.contestClockDisplay.addLabeltoUpdateList(this.clockLabel, ContestClockDisplay.DisplayTimes.REMAINING_TIME, this.contest.getSiteNumber());
        this.controller.register(this.contestClockDisplay);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ServicesView.this.setTitle("PC^2 " + ServicesView.this.contest.getTitle() + " Build " + new VersionInfo().getBuildNumber());
                ServicesView.this.controller.startLogWindow(ServicesView.this.contest);
                ServicesView.this.setFrameTitle(ServicesView.this.contest.getContestTime().isContestRunning());
                try {
                    EventFeedServerPane eventFeedServerPane = new EventFeedServerPane();
                    ServicesView.this.addUIPlugin(ServicesView.this.getMainTabbedPane(), "Event Feed", eventFeedServerPane);
                }
                catch (Exception e) {
                    if (StaticLog.getLog() != null) {
                        StaticLog.getLog().log(Log.WARNING, "Exception", e);
                        e.printStackTrace(System.err);
                    }
                    e.printStackTrace(System.err);
                }
                try {
                    WebServerPane webServerPane = new WebServerPane();
                    ServicesView.this.addUIPlugin(ServicesView.this.getMainTabbedPane(), "Web Services", webServerPane);
                }
                catch (Exception e) {
                    if (StaticLog.getLog() != null) {
                        StaticLog.getLog().log(Log.WARNING, "Exception", e);
                        e.printStackTrace(System.err);
                    }
                    e.printStackTrace(System.err);
                }
                if (Utilities.isDebugMode()) {
                    JPanePlugin pane;
                    try {
                        pane = new PacketMonitorPane();
                        ServicesView.this.addUIPlugin(ServicesView.this.getMainTabbedPane(), "Packets", pane);
                    }
                    catch (Exception e) {
                        ServicesView.this.logException(e);
                    }
                    try {
                        pane = new PluginLoadPane();
                        ((PluginLoadPane)pane).setParentTabbedPane(ServicesView.this.getMainTabbedPane());
                        ServicesView.this.addUIPlugin(ServicesView.this.getMainTabbedPane(), "Plugin Load", pane);
                    }
                    catch (Exception e) {
                        if (StaticLog.getLog() != null) {
                            StaticLog.getLog().log(Log.WARNING, "Exception", e);
                            e.printStackTrace(System.err);
                        }
                        e.printStackTrace(System.err);
                    }
                }
                OptionsPane optionsPanel = new OptionsPane();
                ServicesView.this.addUIPlugin(ServicesView.this.getMainTabbedPane(), "Options", optionsPanel);
                ServicesView.this.showMessage("");
                ServicesView.this.setVisible(true);
            }
        });
    }

    @Override
    public String getPluginTitle() {
        return "Services View";
    }

    protected void addUIPlugin(JTabbedPane tabbedPane, String tabTitle, JPanePlugin plugin) {
        this.controller.register(plugin);
        plugin.setParentFrame(this);
        plugin.setContestAndController(this.contest, this.controller);
        tabbedPane.add((Component)plugin, tabTitle);
    }

    private JTabbedPane getMainTabbedPane() {
        if (this.mainTabbedPane == null) {
            this.mainTabbedPane = new JTabbedPane();
        }
        return this.mainTabbedPane;
    }

    private JPanel getMainViewPane() {
        if (this.mainViewPane == null) {
            this.mainViewPane = new JPanel();
            this.mainViewPane.setLayout(new BorderLayout());
            this.mainViewPane.add((Component)this.getMainTabbedPane(), "Center");
            this.mainViewPane.add((Component)this.getNorthPane(), "North");
        }
        return this.mainViewPane;
    }

    private JPanel getNorthPane() {
        if (this.northPane == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setHorizontalAlignment(0);
            this.messageLabel.setText("JLabel");
            this.clockLabel = new JLabel();
            this.clockLabel.setToolTipText("Time remaining in contest");
            this.clockLabel.setFont(new Font("Dialog", 1, 16));
            this.clockLabel.setHorizontalAlignment(0);
            this.clockLabel.setHorizontalTextPosition(0);
            this.clockLabel.setText("STOPPED ");
            this.northPane = new JPanel();
            this.northPane.setLayout(new BorderLayout());
            this.northPane.add((Component)this.messageLabel, "Center");
            this.northPane.add((Component)this.getEastPane(), "East");
            this.northPane.add((Component)this.getClockPanel(), "West");
        }
        return this.northPane;
    }

    private JPanel getEastPane() {
        if (this.eastPane == null) {
            this.eastPane = new JPanel();
            this.eastPane.add((Component)this.getExitButton(), null);
        }
        return this.eastPane;
    }

    private JButton getExitButton() {
        if (this.exitButton == null) {
            this.exitButton = new JButton();
            this.exitButton.setText("Exit");
            this.exitButton.setToolTipText("Click here to shutdown this PC^2 client");
            this.exitButton.setMnemonic(88);
            this.exitButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ServicesView.this.promptAndExit();
                }
            });
        }
        return this.exitButton;
    }

    private void setFrameTitle(final boolean contestStarted) {
        final ServicesView thisFrame = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrameUtilities.setFrameTitle(thisFrame, ServicesView.this.contest.getTitle(), contestStarted, new VersionInfo());
                if (contestStarted) {
                    ServicesView.this.contestClockDisplay.fireClockStateChange(ServicesView.this.contest.getContestTime());
                } else {
                    ServicesView.this.clockLabel.setText("STOPPED");
                }
                if (ServicesView.this.contestClockDisplay.getClientFrame() == null) {
                    ServicesView.this.contestClockDisplay.setClientFrame(thisFrame);
                }
            }
        });
        FrameUtilities.regularCursor(this);
    }

    protected boolean isThisSite(int siteNumber) {
        return this.contest.getSiteNumber() == siteNumber;
    }

    private void showMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ServicesView.this.messageLabel.setText(string);
                ServicesView.this.messageLabel.setToolTipText(string);
            }
        });
    }

    private void logException(Exception e) {
        if (StaticLog.getLog() != null) {
            StaticLog.getLog().log(Log.WARNING, "Exception", e);
            e.printStackTrace(System.err);
        } else {
            e.printStackTrace(System.err);
        }
    }

    private JPanel getClockPanel() {
        if (this.clockPanel == null) {
            this.clockPanel = new JPanel();
            this.clockPanel.setPreferredSize(new Dimension(85, 34));
            this.clockPanel.setLayout(new BorderLayout());
            this.clockPanel.add((Component)this.clockLabel, "Center");
        }
        return this.clockPanel;
    }

    class ContestTimeListenerImplementation
    implements IContestTimeListener {
        ContestTimeListenerImplementation() {
        }

        @Override
        public void contestTimeAdded(ContestTimeEvent event) {
            this.contestTimeChanged(event);
        }

        @Override
        public void contestTimeRemoved(ContestTimeEvent event) {
            this.contestTimeChanged(event);
        }

        @Override
        public void contestTimeChanged(ContestTimeEvent event) {
            ContestTime contestTime = event.getContestTime();
            if (ServicesView.this.isThisSite(contestTime.getSiteNumber())) {
                ServicesView.this.setFrameTitle(contestTime.isContestRunning());
            }
        }

        @Override
        public void contestStarted(ContestTimeEvent event) {
            this.contestTimeChanged(event);
        }

        @Override
        public void contestStopped(ContestTimeEvent event) {
            this.contestTimeChanged(event);
        }

        @Override
        public void refreshAll(ContestTimeEvent event) {
            this.contestTimeChanged(event);
        }
    }
}

