/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui.admin;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.IniFile;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.ContestTimeEvent;
import edu.csus.ecs.pc2.core.model.IContestTimeListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.IProfileListener;
import edu.csus.ecs.pc2.core.model.ProfileEvent;
import edu.csus.ecs.pc2.ui.AccountsPane;
import edu.csus.ecs.pc2.ui.AutoJudgesPane;
import edu.csus.ecs.pc2.ui.BalloonSettingsPane;
import edu.csus.ecs.pc2.ui.CategoriesPane;
import edu.csus.ecs.pc2.ui.ClarificationsPane;
import edu.csus.ecs.pc2.ui.ConnectionsPane;
import edu.csus.ecs.pc2.ui.ContestClockDisplay;
import edu.csus.ecs.pc2.ui.ContestInformationPane;
import edu.csus.ecs.pc2.ui.ContestPreloadPane;
import edu.csus.ecs.pc2.ui.ContestTimesPane;
import edu.csus.ecs.pc2.ui.EventFeedServerPane;
import edu.csus.ecs.pc2.ui.ExportDataPane;
import edu.csus.ecs.pc2.ui.FinalizePane;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.GroupsPane;
import edu.csus.ecs.pc2.ui.ICPCLoadPane;
import edu.csus.ecs.pc2.ui.ImportDataPane;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.JudgementsPane;
import edu.csus.ecs.pc2.ui.LanguagesPane;
import edu.csus.ecs.pc2.ui.LogWindow;
import edu.csus.ecs.pc2.ui.LoginsPane;
import edu.csus.ecs.pc2.ui.MessageMonitorPane;
import edu.csus.ecs.pc2.ui.OptionsPane;
import edu.csus.ecs.pc2.ui.PacketExplorerPane;
import edu.csus.ecs.pc2.ui.PacketMonitorPane;
import edu.csus.ecs.pc2.ui.PlaybackPane;
import edu.csus.ecs.pc2.ui.PluginLoadPane;
import edu.csus.ecs.pc2.ui.ProblemsPane;
import edu.csus.ecs.pc2.ui.ProfilesPane;
import edu.csus.ecs.pc2.ui.ReportPane;
import edu.csus.ecs.pc2.ui.RunsPane;
import edu.csus.ecs.pc2.ui.SitesPane;
import edu.csus.ecs.pc2.ui.StandingsHTMLPane;
import edu.csus.ecs.pc2.ui.StandingsPane;
import edu.csus.ecs.pc2.ui.TeamStatusPane;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AdministratorView
extends JFrame
implements UIPlugin,
ChangeListener {
    private static final long serialVersionUID = 1L;
    private IInternalContest contest;
    private IInternalController controller;
    private JPanel jPanel = null;
    private JTabbedPane mainTabbedPanel = null;
    private JPanel statusPanel = null;
    private JPanel topPanel = null;
    private JButton exitButton = null;
    private LogWindow securityAlertLogWindow = null;
    private JPanel clockPane = null;
    private JPanel exitButtonPane = null;
    private JLabel clockLabel = null;
    private JPanel padPane = null;
    private ContestClockDisplay contestClockDisplay = null;
    private JTabbedPane configureContestTabbedPane = null;
    private JTabbedPane runContestTabbedPane = null;
    private static final Color ACTIVE_TAB_COLOR = Color.BLUE;
    private static final Color INACTIVE_TAB_COLOR = Color.GRAY;
    private JPanel centerPane = null;
    private JPanel aMessagePane = null;
    private JLabel messageLabel = null;

    public AdministratorView() {
        this.initialize();
    }

    private void initialize() {
        this.setDefaultCloseOperation(0);
        this.setBounds(new Rectangle(0, 0, 900, 500));
        this.setContentPane(this.getJPanel());
        this.setTitle("PC^2 Administrator");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AdministratorView.this.promptAndExit();
            }
        });
        this.getMainTabbedPanel().addChangeListener(this);
        this.overRideLookAndFeel();
        FrameUtilities.centerFrame(this);
    }

    private void overRideLookAndFeel() {
        String value = IniFile.getValue("client.plaf");
        if (value != null && value.equalsIgnoreCase("java")) {
            FrameUtilities.setJavaLookAndFeel();
        }
        if (value != null && value.equalsIgnoreCase("native")) {
            FrameUtilities.setNativeLookAndFeel();
        }
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        final AdministratorView thisFrame = this;
        this.updateProfileLabel();
        AdminListeners adminListeners = new AdminListeners();
        adminListeners.setContestAndController(inContest, inController);
        this.controller.register(adminListeners);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AdministratorView.this.controller.startLogWindow(AdministratorView.this.contest);
                AdministratorView.this.initializeSecurityAlertWindow(AdministratorView.this.contest);
                int fontSize = AdministratorView.this.getMainTabbedPanel().getFont().getSize();
                AdministratorView.this.getMainTabbedPanel().setFont(AdministratorView.this.getMainTabbedPanel().getFont().deriveFont(1, fontSize + 6));
                AdministratorView.this.getMainTabbedPanel().setTitleAt(0, "Configure Contest");
                AdministratorView.this.getMainTabbedPanel().setForegroundAt(0, ACTIVE_TAB_COLOR);
                AdministratorView.this.getMainTabbedPanel().setTitleAt(1, "Run Contest");
                AdministratorView.this.getMainTabbedPanel().setForegroundAt(1, INACTIVE_TAB_COLOR);
                AccountsPane accountsPane = new AccountsPane();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getConfigureContestTabbedPane(), "Accounts", accountsPane);
                if (Utilities.isDebugMode()) {
                    try {
                        CategoriesPane categoriesPane = new CategoriesPane();
                        AdministratorView.this.addUIPlugin(AdministratorView.this.getConfigureContestTabbedPane(), "Clar Categories", categoriesPane);
                        ContestPreloadPane contestPreloadPane = new ContestPreloadPane();
                        AdministratorView.this.addUIPlugin(AdministratorView.this.getConfigureContestTabbedPane(), "Contests", contestPreloadPane);
                    }
                    catch (Exception e) {
                        AdministratorView.this.logException(e);
                    }
                }
                AutoJudgesPane autoJudgesPane = new AutoJudgesPane();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getConfigureContestTabbedPane(), "Auto Judge", autoJudgesPane);
                GroupsPane groupsPane = new GroupsPane();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getConfigureContestTabbedPane(), "Groups", groupsPane);
                ICPCLoadPane icpcPane = new ICPCLoadPane();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getConfigureContestTabbedPane(), "ICPC", icpcPane);
                ImportDataPane importDataPane = new ImportDataPane();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getConfigureContestTabbedPane(), "Import CCS", importDataPane);
                JudgementsPane judgementsPanel = new JudgementsPane();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getConfigureContestTabbedPane(), "Judgements", judgementsPanel);
                LanguagesPane languagesPane = new LanguagesPane();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getConfigureContestTabbedPane(), "Languages", languagesPane);
                BalloonSettingsPane balloonSettingsPane = new BalloonSettingsPane();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getConfigureContestTabbedPane(), "Notifications", balloonSettingsPane);
                if (Utilities.isDebugMode()) {
                    try {
                        PacketExplorerPane explorerPane = new PacketExplorerPane();
                        AdministratorView.this.addUIPlugin(AdministratorView.this.getConfigureContestTabbedPane(), "Packets", explorerPane);
                    }
                    catch (Exception e) {
                        AdministratorView.this.logException(e);
                    }
                }
                ProblemsPane problemsPane = new ProblemsPane();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getConfigureContestTabbedPane(), "Problems", problemsPane);
                ProfilesPane profilesPane = new ProfilesPane();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getConfigureContestTabbedPane(), "Profiles", profilesPane);
                ReportPane reportPaneC = new ReportPane();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getConfigureContestTabbedPane(), "Reports", reportPaneC);
                ContestInformationPane contestInformationPane = new ContestInformationPane();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getConfigureContestTabbedPane(), "Settings", contestInformationPane);
                ContestTimesPane contestTimesPane = new ContestTimesPane();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getConfigureContestTabbedPane(), "Times", contestTimesPane);
                ConnectionsPane connectionsPane = new ConnectionsPane();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getRunContestTabbedPane(), "Connections", connectionsPane);
                ClarificationsPane clarificationsPane = new ClarificationsPane();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getRunContestTabbedPane(), "Clarifications", clarificationsPane);
                if (Utilities.isDebugMode()) {
                    try {
                        EventFeedServerPane eventFeedServerPane = new EventFeedServerPane();
                        AdministratorView.this.addUIPlugin(AdministratorView.this.getRunContestTabbedPane(), "Event Feed Server", eventFeedServerPane);
                    }
                    catch (Exception e) {
                        AdministratorView.this.logException(e);
                    }
                }
                ExportDataPane exportPane = new ExportDataPane();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getRunContestTabbedPane(), "Export", exportPane);
                FinalizePane finalizePane = new FinalizePane();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getRunContestTabbedPane(), "Finalize", finalizePane);
                LoginsPane loginsPane = new LoginsPane();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getRunContestTabbedPane(), "Logins", loginsPane);
                if (Utilities.isDebugMode()) {
                    try {
                        MessageMonitorPane messageMonitorPane = new MessageMonitorPane();
                        AdministratorView.this.addUIPlugin(AdministratorView.this.getRunContestTabbedPane(), "Messages", messageMonitorPane);
                    }
                    catch (Exception e) {
                        AdministratorView.this.logException(e);
                    }
                }
                OptionsPane optionsPanel = new OptionsPane();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getRunContestTabbedPane(), "Options", optionsPanel);
                optionsPanel.setSecurityLogWindow(AdministratorView.this.securityAlertLogWindow);
                if (Utilities.isDebugMode()) {
                    try {
                        PacketMonitorPane pane = new PacketMonitorPane();
                        AdministratorView.this.addUIPlugin(AdministratorView.this.getRunContestTabbedPane(), "Packets", pane);
                    }
                    catch (Exception e) {
                        AdministratorView.this.logException(e);
                    }
                }
                if (Utilities.isDebugMode()) {
                    try {
                        PlaybackPane playbackPane = new PlaybackPane();
                        AdministratorView.this.addUIPlugin(AdministratorView.this.getRunContestTabbedPane(), "Replay", playbackPane);
                        PluginLoadPane pane = new PluginLoadPane();
                        pane.setParentTabbedPane(AdministratorView.this.getRunContestTabbedPane());
                        AdministratorView.this.addUIPlugin(AdministratorView.this.getRunContestTabbedPane(), "Plugin Load", pane);
                    }
                    catch (Exception e) {
                        AdministratorView.this.logException(e);
                    }
                }
                ReportPane reportPane = new ReportPane();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getRunContestTabbedPane(), "Reports", reportPane);
                RunsPane runsPane = new RunsPane();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getRunContestTabbedPane(), "Runs", runsPane);
                SitesPane sitesPanel = new SitesPane();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getRunContestTabbedPane(), "Sites", sitesPanel);
                StandingsPane standingsPane = new StandingsPane();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getRunContestTabbedPane(), "Standings", standingsPane);
                StandingsHTMLPane standingsHTMLPane = new StandingsHTMLPane("full.xsl");
                AdministratorView.this.addUIPlugin(AdministratorView.this.getRunContestTabbedPane(), "Standings HTML", standingsHTMLPane);
                TeamStatusPane teamStatusPane = new TeamStatusPane();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getRunContestTabbedPane(), "Team Status", teamStatusPane);
                AdministratorView.this.setSelectedTab(AdministratorView.this.getRunContestTabbedPane(), "Runs");
                AdministratorView.this.setSelectedTab(AdministratorView.this.getConfigureContestTabbedPane(), "Accounts");
                AdministratorView.this.contestClockDisplay = new ContestClockDisplay(AdministratorView.this.controller.getLog(), AdministratorView.this.contest.getContestTime(), AdministratorView.this.contest.getSiteNumber(), false, null);
                AdministratorView.this.contestClockDisplay.setContestAndController(AdministratorView.this.contest, AdministratorView.this.controller);
                AdministratorView.this.contestClockDisplay.addLabeltoUpdateList(AdministratorView.this.clockLabel, ContestClockDisplay.DisplayTimes.REMAINING_TIME, AdministratorView.this.contest.getSiteNumber());
                AdministratorView.this.contestClockDisplay.setClientFrame(thisFrame);
                AdministratorView.this.contest.addContestTimeListener(new ContestTimeListenerImplementation());
                AdministratorView.this.controller.register(AdministratorView.this.contestClockDisplay);
                FrameUtilities.setFrameTitle(thisFrame, AdministratorView.this.contest.getTitle(), AdministratorView.this.contest.getContestTime().isContestRunning(), new VersionInfo());
                AdministratorView.this.setVisible(true);
            }
        });
    }

    protected void setSelectedTab(JTabbedPane tabbedPane, String name) {
        int i = 0;
        while (i < tabbedPane.getComponentCount()) {
            String tabTitle = tabbedPane.getTitleAt(i);
            if (tabTitle != null && name.equals(tabTitle)) {
                tabbedPane.setSelectedIndex(i);
            }
            ++i;
        }
    }

    private void logException(Exception e) {
        if (StaticLog.getLog() != null) {
            StaticLog.getLog().log(Log.WARNING, "Exception", e);
            e.printStackTrace(System.err);
        } else {
            e.printStackTrace(System.err);
        }
    }

    protected void initializeSecurityAlertWindow(IInternalContest inContest) {
        if (this.securityAlertLogWindow == null) {
            this.securityAlertLogWindow = new LogWindow(inContest.getSecurityAlertLog());
        }
        this.securityAlertLogWindow.setContestAndController(inContest, this.controller);
        this.securityAlertLogWindow.setTitle("Contest Security Alerts " + inContest.getClientId().toString());
        VersionInfo versionInfo = new VersionInfo();
        this.securityAlertLogWindow.getLog().info("Security Log Started " + versionInfo.getSystemVersionInfo());
    }

    @Override
    public String getPluginTitle() {
        return "Admin GUI";
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.add((Component)this.getMainTabbedPanel(), "Center");
            this.jPanel.add((Component)this.getTopPanel(), "North");
            this.jPanel.add((Component)this.getStatusPanel(), "South");
        }
        return this.jPanel;
    }

    private JTabbedPane getMainTabbedPanel() {
        if (this.mainTabbedPanel == null) {
            this.mainTabbedPanel = new JTabbedPane();
            this.mainTabbedPanel.addTab(null, null, this.getConfigureContestTabbedPane(), null);
            this.mainTabbedPanel.addTab(null, null, this.getRunContestTabbedPane(), null);
        }
        return this.mainTabbedPanel;
    }

    private JPanel getStatusPanel() {
        if (this.statusPanel == null) {
            this.statusPanel = new JPanel();
            this.statusPanel.setPreferredSize(new Dimension(30, 30));
        }
        return this.statusPanel;
    }

    private JPanel getTopPanel() {
        if (this.topPanel == null) {
            this.topPanel = new JPanel();
            this.topPanel.setLayout(new BorderLayout());
            this.topPanel.setPreferredSize(new Dimension(45, 45));
            this.topPanel.add((Component)this.getExitButtonPane(), "East");
            this.topPanel.add((Component)this.getPadPane(), "West");
            this.topPanel.add((Component)this.getCenterPane(), "Center");
        }
        return this.topPanel;
    }

    private JButton getExitButton() {
        if (this.exitButton == null) {
            this.exitButton = new JButton();
            this.exitButton.setText("Exit");
            this.exitButton.setToolTipText("Click here to Shutdown PC^2");
            this.exitButton.setMnemonic(88);
            this.exitButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AdministratorView.this.promptAndExit();
                }
            });
        }
        return this.exitButton;
    }

    protected void promptAndExit() {
        int result = FrameUtilities.yesNoCancelDialog(null, "Are you sure you want to exit PC^2?", "Exit PC^2");
        if (result == 0) {
            System.exit(0);
        }
    }

    protected void addUIPlugin(JTabbedPane tabbedPane, String tabTitle, JPanePlugin plugin) {
        if (plugin == null) {
            return;
        }
        try {
            this.controller.register(plugin);
            plugin.setParentFrame(this);
            plugin.setContestAndController(this.contest, this.controller);
            tabbedPane.add((Component)plugin, tabTitle);
        }
        catch (Exception e) {
            this.controller.getLog().log(Log.WARNING, "Exception loading plugin ", e);
            JOptionPane.showMessageDialog(this, "Error loading " + plugin.getPluginTitle());
        }
    }

    protected void showLog(boolean showLogWindow) {
        this.controller.showLogWindow(showLogWindow);
    }

    private JPanel getClockPane() {
        if (this.clockPane == null) {
            this.clockLabel = new JLabel();
            this.clockLabel.setText("STOPPED");
            this.clockLabel.setPreferredSize(new Dimension(100, 24));
            this.clockLabel.setFont(new Font("Dialog", 1, 18));
            this.clockPane = new JPanel();
            this.clockPane.setLayout(new BorderLayout());
            this.clockPane.setPreferredSize(new Dimension(85, 34));
            this.clockPane.add((Component)this.clockLabel, "West");
        }
        return this.clockPane;
    }

    private JPanel getExitButtonPane() {
        if (this.exitButtonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(10);
            flowLayout.setVgap(10);
            this.exitButtonPane = new JPanel();
            this.exitButtonPane.setLayout(flowLayout);
            this.exitButtonPane.add((Component)this.getExitButton(), null);
        }
        return this.exitButtonPane;
    }

    private JPanel getPadPane() {
        if (this.padPane == null) {
            this.padPane = new JPanel();
            this.padPane.setPreferredSize(new Dimension(10, 10));
        }
        return this.padPane;
    }

    private JTabbedPane getConfigureContestTabbedPane() {
        if (this.configureContestTabbedPane == null) {
            this.configureContestTabbedPane = new JTabbedPane();
            this.configureContestTabbedPane.setToolTipText("");
            this.configureContestTabbedPane.setName("Configure Contest");
        }
        return this.configureContestTabbedPane;
    }

    private JTabbedPane getRunContestTabbedPane() {
        if (this.runContestTabbedPane == null) {
            this.runContestTabbedPane = new JTabbedPane();
        }
        return this.runContestTabbedPane;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.getMainTabbedPanel()) {
            int tabCount = this.getMainTabbedPanel().getTabCount();
            int i = 0;
            while (i < tabCount) {
                this.getMainTabbedPanel().setForegroundAt(i, INACTIVE_TAB_COLOR);
                ++i;
            }
        } else {
            throw new RuntimeException("Unexpected ChangeEvent: " + e);
        }
        int selectedTab = this.getMainTabbedPanel().getSelectedIndex();
        this.getMainTabbedPanel().setForegroundAt(selectedTab, ACTIVE_TAB_COLOR);
    }

    private JPanel getCenterPane() {
        if (this.centerPane == null) {
            this.centerPane = new JPanel();
            this.centerPane.setLayout(new BorderLayout());
            this.centerPane.add((Component)this.getClockPane(), "West");
            this.centerPane.add((Component)this.getAMessagePane(), "Center");
        }
        return this.centerPane;
    }

    private JPanel getAMessagePane() {
        if (this.aMessagePane == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setText("");
            this.messageLabel.setHorizontalAlignment(0);
            this.messageLabel.setFont(new Font("Dialog", 1, 18));
            this.messageLabel.setForeground(new Color(0, 186, 0));
            this.messageLabel.setHorizontalTextPosition(0);
            this.aMessagePane = new JPanel();
            this.aMessagePane.setLayout(new BorderLayout());
            this.aMessagePane.add((Component)this.messageLabel, "Center");
        }
        return this.aMessagePane;
    }

    public static void main(String[] args) {
        AdministratorView administratorView = new AdministratorView();
        administratorView.setVisible(true);
    }

    protected boolean isThisSite(int siteNumber) {
        return this.contest.getSiteNumber() == siteNumber;
    }

    private void setFrameTitle(final boolean contestStarted) {
        final AdministratorView thisFrame = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrameUtilities.setFrameTitle(thisFrame, AdministratorView.this.contest.getTitle(), contestStarted, new VersionInfo());
                if (contestStarted) {
                    AdministratorView.this.contestClockDisplay.fireClockStateChange(AdministratorView.this.contest.getContestTime());
                } else {
                    AdministratorView.this.clockLabel.setText("STOPPED");
                }
                if (AdministratorView.this.contestClockDisplay.getClientFrame() == null) {
                    AdministratorView.this.contestClockDisplay.setClientFrame(thisFrame);
                }
            }
        });
        FrameUtilities.regularCursor(this);
    }

    private void updateProfileLabel() {
        int numberProfiles = this.contest.getProfiles().length;
        String s = "";
        if (numberProfiles > 1) {
            s = "Active Profile is: \"" + this.contest.getProfile().getName() + "\"";
        }
        final String message = s;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AdministratorView.this.messageLabel.setText(message);
            }
        });
    }

    protected class AdminListeners
    implements UIPlugin {
        private static final long serialVersionUID = 3733076435840880891L;

        protected AdminListeners() {
        }

        @Override
        public void setContestAndController(IInternalContest inContest, IInternalController inController) {
            inContest.addProfileListener(new ProfileListenerImplementation());
        }

        @Override
        public String getPluginTitle() {
            return "AdminListeners";
        }
    }

    class ContestTimeListenerImplementation
    implements IContestTimeListener {
        ContestTimeListenerImplementation() {
        }

        @Override
        public void contestTimeAdded(ContestTimeEvent event) {
            this.contestTimeChanged(event);
        }

        @Override
        public void contestTimeRemoved(ContestTimeEvent event) {
            this.contestTimeChanged(event);
        }

        @Override
        public void contestTimeChanged(ContestTimeEvent event) {
            ContestTime contestTime = event.getContestTime();
            if (AdministratorView.this.isThisSite(contestTime.getSiteNumber())) {
                AdministratorView.this.setFrameTitle(contestTime.isContestRunning());
            }
        }

        @Override
        public void contestStarted(ContestTimeEvent event) {
            this.contestTimeChanged(event);
        }

        @Override
        public void contestStopped(ContestTimeEvent event) {
            this.contestTimeChanged(event);
        }

        @Override
        public void refreshAll(ContestTimeEvent event) {
            this.contestTimeChanged(event);
        }
    }

    protected class ProfileListenerImplementation
    implements IProfileListener {
        protected ProfileListenerImplementation() {
        }

        @Override
        public void profileAdded(ProfileEvent event) {
            AdministratorView.this.updateProfileLabel();
        }

        @Override
        public void profileChanged(ProfileEvent event) {
            AdministratorView.this.updateProfileLabel();
        }

        @Override
        public void profileRemoved(ProfileEvent event) {
        }

        @Override
        public void profileRefreshAll(ProfileEvent profileEvent) {
            AdministratorView.this.updateProfileLabel();
        }
    }
}

