/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.services.web.LanguageService;
import edu.csus.ecs.pc2.services.web.ProblemService;
import edu.csus.ecs.pc2.services.web.ScoreboardService;
import edu.csus.ecs.pc2.services.web.StarttimeService;
import edu.csus.ecs.pc2.services.web.TeamService;
import edu.csus.ecs.pc2.ui.IntegerDocument;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.servlet.Servlet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.filter.RolesAllowedDynamicFeature;
import org.glassfish.jersey.servlet.ServletContainer;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.CertificateIssuerName;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateSubjectName;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.KeyIdentifier;
import sun.security.x509.SubjectKeyIdentifierExtension;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public class WebServerPane
extends JPanePlugin {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_WEB_SERVER_PORT_NUMBER = 50443;
    private JPanel buttonPanel = null;
    private JButton startButton = null;
    private JButton stopButton = null;
    private JPanel centerPanel = null;
    private JLabel portLabel = null;
    private JTextField portTextField = null;
    private Server jettyServer = null;
    private JLabel webServerStatusLabel = null;
    private JCheckBox chckbxScoreboard;
    private JLabel lblEnabledWebServices;
    private JCheckBox chckbxProblems;
    private JCheckBox chckbxLanguages;
    private JCheckBox chckbxStarttime;
    private JCheckBox chckbxTeams;
    private String keystorePassword = "i don't care";

    public WebServerPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(505, 250));
        this.add((Component)this.getButtonPanel(), "South");
        this.add((Component)this.getCenterPanel(), "Center");
        this.updateGUI();
    }

    @Override
    public String getPluginTitle() {
        return "Web Server Pane";
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(25);
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(flowLayout);
            this.buttonPanel.setPreferredSize(new Dimension(35, 35));
            this.buttonPanel.add((Component)this.getStartButton(), null);
            this.buttonPanel.add((Component)this.getStopButton(), null);
        }
        return this.buttonPanel;
    }

    private JButton getStartButton() {
        if (this.startButton == null) {
            this.startButton = new JButton();
            this.startButton.setText("Start");
            this.startButton.setMnemonic(83);
            this.startButton.setToolTipText("Start Web Server");
            this.startButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WebServerPane.this.startWebServer();
                }
            });
        }
        return this.startButton;
    }

    private void startWebServer() {
        if (this.portTextField.getText() == null) {
            this.showMessage("You must enter a port number");
            return;
        }
        if (this.portTextField.getText().length() == 0) {
            this.showMessage("You must enter a port number");
            return;
        }
        try {
            int port = Integer.parseInt(this.portTextField.getText());
            File keystoreFile = new File("cacerts.pc2");
            if (!keystoreFile.exists()) {
                this.createKeyStoreAndKey(keystoreFile);
            }
            ServletContextHandler context = new ServletContextHandler(1);
            context.setContextPath("/");
            context.addServlet(new ServletHolder((Servlet)new ServletContainer(this.getResourceConfig())), "/*");
            this.jettyServer = new Server();
            HttpConfiguration httpConfig = new HttpConfiguration();
            httpConfig.setSecureScheme("https");
            httpConfig.setSecurePort(port);
            httpConfig.setOutputBufferSize(32768);
            SslContextFactory sslContextFactory = new SslContextFactory(true);
            sslContextFactory.setKeyStorePath(keystoreFile.getAbsolutePath());
            sslContextFactory.setKeyStorePassword(this.keystorePassword);
            sslContextFactory.setKeyManagerPassword(this.keystorePassword);
            sslContextFactory.setIncludeCipherSuites(new String[]{"TLS_DHE_RSA.*", "TLS_ECDHE.*"});
            sslContextFactory.setExcludeProtocols(new String[]{"SSL", "SSLv2", "SSLv2Hello", "SSLv3"});
            sslContextFactory.setRenegotiationAllowed(false);
            HttpConfiguration httpsConfig = new HttpConfiguration(httpConfig);
            httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            ServerConnector https = new ServerConnector(this.jettyServer, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(httpsConfig)});
            https.setPort(port);
            https.setIdleTimeout(0L);
            this.jettyServer.setConnectors(new Connector[]{https});
            this.jettyServer.setHandler((Handler)context);
            this.jettyServer.start();
        }
        catch (NumberFormatException e) {
            this.showMessage("Unable to start web services: invalid port number: " + e.getMessage());
            e.printStackTrace();
            this.getLog().log(Log.INFO, e.getMessage(), e);
        }
        catch (IOException e1) {
            this.showMessage("Unable to start web services: " + e1.getMessage());
            e1.printStackTrace();
            this.getLog().log(Log.INFO, e1.getMessage(), e1);
        }
        catch (Exception e2) {
            this.showMessage("Unable to start web services: " + e2.getMessage());
            e2.printStackTrace();
            this.getLog().log(Log.INFO, e2.getMessage(), e2);
        }
        this.updateGUI();
    }

    private X509Certificate generateCertificate(String dn, KeyPair pair, int days, String algorithm) throws GeneralSecurityException, IOException {
        PrivateKey privkey = pair.getPrivate();
        X509CertInfo info = new X509CertInfo();
        Date from = new Date();
        Date to = new Date(from.getTime() + (long)days * 86400000L);
        CertificateValidity interval = new CertificateValidity(from, to);
        BigInteger sn = new BigInteger(64, new SecureRandom());
        X500Name owner = new X500Name(dn);
        info.set("validity", interval);
        info.set("serialNumber", new CertificateSerialNumber(sn));
        info.set("subject", new CertificateSubjectName(owner));
        info.set("issuer", new CertificateIssuerName(owner));
        info.set("key", new CertificateX509Key(pair.getPublic()));
        info.set("version", new CertificateVersion(2));
        AlgorithmId algo = new AlgorithmId(AlgorithmId.md5WithRSAEncryption_oid);
        info.set("algorithmID", new CertificateAlgorithmId(algo));
        X509CertImpl cert = new X509CertImpl(info);
        cert.sign(privkey, algorithm);
        algo = (AlgorithmId)cert.get("x509.algorithm");
        info.set("algorithmID.algorithm", algo);
        cert = new X509CertImpl(info);
        cert.sign(privkey, algorithm);
        return cert;
    }

    private void createKeyStoreAndKey(File keystoreFile) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, FileNotFoundException {
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        char[] password = this.keystorePassword.toCharArray();
        ks.load(null, password);
        try {
            String dn = "CN=pc2 jetty, OU=PC^2, O=PC^2, L=Unknown, ST=Unknown, C=Unknown";
            if (System.getProperty("java.version").matches("^1\\.[7]\\..*")) {
                int days = 365;
                KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
                KeyPair keypair = keyGen.generateKeyPair();
                X509Certificate tmpCert = this.generateCertificate(dn, keypair, days, "SHA256WithRSA");
                Certificate[] chain = new X509Certificate[]{tmpCert};
                ks.setCertificateEntry("jetty", tmpCert);
                ks.setKeyEntry("jetty", keypair.getPrivate(), this.keystorePassword.toCharArray(), chain);
            } else {
                String certAndKeyGen = System.getProperty("java.version").matches("^1\\.[67]\\..*") ? "sun.security.x509.CertAndKeyGen" : "sun.security.tools.keytool.CertAndKeyGen";
                String x500Name = "sun.security.x509.X500Name";
                Class<?> certKeyGenClass = Class.forName(certAndKeyGen);
                Class<?> x500NameClass = Class.forName(x500Name);
                Constructor<?> certKeyGenCons = certKeyGenClass.getConstructor(String.class, String.class);
                Constructor<?> x500NameCons = x500NameClass.getConstructor(String.class);
                Object keypair = certKeyGenCons.newInstance("RSA", "SHA256WithRSA");
                Object subject = x500NameCons.newInstance(dn);
                Method certAndKeyGenGenerate = certKeyGenClass.getMethod("generate", Integer.TYPE);
                certAndKeyGenGenerate.invoke(keypair, 2048);
                Method certAndKeyGenPrivateKey = certKeyGenClass.getMethod("getPrivateKey", new Class[0]);
                PrivateKey rootPrivateKey = (PrivateKey)certAndKeyGenPrivateKey.invoke(keypair, new Object[0]);
                Method getSelfCertificate = certKeyGenClass.getMethod("getSelfCertificate", x500NameClass, Long.TYPE);
                Certificate[] chain = new X509Certificate[1];
                long days = 31536000L;
                chain[0] = (X509Certificate)getSelfCertificate.invoke(keypair, subject, days);
                Principal issuer = chain[0].getSubjectDN();
                String issuerSigAlg = chain[0].getSigAlgName();
                byte[] inCertBytes = chain[0].getTBSCertificate();
                X509CertInfo info = new X509CertInfo(inCertBytes);
                info.set("issuer", (X500Name)issuer);
                CertificateExtensions exts = new CertificateExtensions();
                exts.set("SubjectKeyIdentifier", new SubjectKeyIdentifierExtension(new KeyIdentifier(chain[0].getPublicKey()).getIdentifier()));
                info.set("extensions", exts);
                X509CertImpl outCert = new X509CertImpl(info);
                outCert.sign(rootPrivateKey, issuerSigAlg);
                ks.setCertificateEntry("jetty", outCert);
                ks.setKeyEntry("jetty", rootPrivateKey, this.keystorePassword.toCharArray(), chain);
            }
            FileOutputStream fos = new FileOutputStream(keystoreFile);
            ks.store(fos, password);
            fos.close();
        }
        catch (Exception ex) {
            System.out.println("ERROR: cannot create " + keystoreFile + ", " + ex.getMessage());
            System.out.println("This is known problem with java7, works properly with java8");
            this.getLog().throwing("WebServerPane", "createKeyStoreAndKey", ex);
        }
    }

    private ResourceConfig getResourceConfig() {
        ResourceConfig resConfig = new ResourceConfig();
        resConfig.register(RolesAllowedDynamicFeature.class);
        if (this.getChckbxScoreboard().isSelected()) {
            resConfig.register((Object)new ScoreboardService(this.getContest(), this.getController()));
        }
        if (this.getChckbxProblems().isSelected()) {
            resConfig.register((Object)new ProblemService(this.getContest(), this.getController()));
        }
        if (this.getChckbxLanguages().isSelected()) {
            resConfig.register((Object)new LanguageService(this.getContest(), this.getController()));
        }
        if (this.getChckbxStarttime().isSelected()) {
            resConfig.register((Object)new StarttimeService(this.getContest(), this.getController()));
        }
        if (this.getChckbxTeams().isSelected()) {
            resConfig.register((Object)new TeamService(this.getContest(), this.getController()));
        }
        return resConfig;
    }

    private void showMessage(String string) {
        JOptionPane.showMessageDialog(this, string);
    }

    private JButton getStopButton() {
        if (this.stopButton == null) {
            this.stopButton = new JButton();
            this.stopButton.setText("Stop");
            this.stopButton.setMnemonic(84);
            this.stopButton.setToolTipText("Stop Web Server");
            this.stopButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WebServerPane.this.stopWebServer();
                }
            });
        }
        return this.stopButton;
    }

    protected void stopWebServer() {
        if (this.jettyServer != null) {
            try {
                this.jettyServer.stop();
            }
            catch (Exception e1) {
                this.showMessage("Unable to stop Jetty webserver: " + e1.getMessage());
                e1.printStackTrace();
                this.getLog().log(Log.INFO, e1.getMessage(), e1);
            }
            this.jettyServer.destroy();
        }
        this.updateGUI();
    }

    private JPanel getCenterPanel() {
        if (this.centerPanel == null) {
            this.centerPanel = new JPanel();
            GridBagLayout gblCenterPanel = new GridBagLayout();
            int[] nArray = new int[4];
            nArray[0] = 198;
            nArray[1] = 57;
            nArray[2] = 167;
            gblCenterPanel.columnWidths = nArray;
            int[] nArray2 = new int[7];
            nArray2[0] = 36;
            nArray2[1] = 23;
            nArray2[2] = 32;
            nArray2[3] = 23;
            gblCenterPanel.rowHeights = nArray2;
            gblCenterPanel.columnWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
            gblCenterPanel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
            this.centerPanel.setLayout(gblCenterPanel);
            this.webServerStatusLabel = new JLabel();
            this.webServerStatusLabel.setFont(new Font("Dialog", 1, 14));
            this.webServerStatusLabel.setHorizontalAlignment(0);
            this.webServerStatusLabel.setText("Web Server NOT running");
            GridBagConstraints gbcEventFeedServerStatusLabel = new GridBagConstraints();
            gbcEventFeedServerStatusLabel.fill = 1;
            gbcEventFeedServerStatusLabel.insets = new Insets(0, 0, 5, 0);
            gbcEventFeedServerStatusLabel.gridwidth = 3;
            gbcEventFeedServerStatusLabel.gridx = 0;
            gbcEventFeedServerStatusLabel.gridy = 0;
            this.centerPanel.add((Component)this.webServerStatusLabel, gbcEventFeedServerStatusLabel);
            this.portLabel = new JLabel();
            this.portLabel.setPreferredSize(new Dimension(52, 26));
            this.portLabel.setHorizontalAlignment(4);
            this.portLabel.setText("Web Server port");
            GridBagConstraints gbcportLabel = new GridBagConstraints();
            gbcportLabel.fill = 1;
            gbcportLabel.insets = new Insets(0, 0, 5, 5);
            gbcportLabel.gridx = 0;
            gbcportLabel.gridy = 1;
            this.centerPanel.add((Component)this.portLabel, gbcportLabel);
            GridBagConstraints gbcunFilteredPortTextField = new GridBagConstraints();
            gbcunFilteredPortTextField.fill = 2;
            gbcunFilteredPortTextField.insets = new Insets(0, 0, 5, 5);
            gbcunFilteredPortTextField.gridx = 1;
            gbcunFilteredPortTextField.gridy = 1;
            this.centerPanel.add((Component)this.getPortTextField(), gbcunFilteredPortTextField);
            GridBagConstraints gbc_lblEnabledWebServices = new GridBagConstraints();
            gbc_lblEnabledWebServices.anchor = 13;
            gbc_lblEnabledWebServices.insets = new Insets(0, 0, 5, 5);
            gbc_lblEnabledWebServices.gridx = 0;
            gbc_lblEnabledWebServices.gridy = 2;
            this.centerPanel.add((Component)this.getLblEnabledWebServices(), gbc_lblEnabledWebServices);
            GridBagConstraints gbc_chckbxScoreboard = new GridBagConstraints();
            gbc_chckbxScoreboard.anchor = 17;
            gbc_chckbxScoreboard.insets = new Insets(0, 0, 5, 5);
            gbc_chckbxScoreboard.gridx = 1;
            gbc_chckbxScoreboard.gridy = 2;
            this.centerPanel.add((Component)this.getChckbxScoreboard(), gbc_chckbxScoreboard);
            GridBagConstraints gbc_chckbxTeams = new GridBagConstraints();
            gbc_chckbxTeams.anchor = 17;
            gbc_chckbxTeams.insets = new Insets(0, 0, 5, 0);
            gbc_chckbxTeams.gridx = 2;
            gbc_chckbxTeams.gridy = 2;
            this.centerPanel.add((Component)this.getChckbxTeams(), gbc_chckbxTeams);
            GridBagConstraints gbc_chckbxProblems = new GridBagConstraints();
            gbc_chckbxProblems.anchor = 17;
            gbc_chckbxProblems.insets = new Insets(0, 0, 5, 5);
            gbc_chckbxProblems.gridx = 1;
            gbc_chckbxProblems.gridy = 3;
            this.centerPanel.add((Component)this.getChckbxProblems(), gbc_chckbxProblems);
            GridBagConstraints gbc_chckbxLanguages = new GridBagConstraints();
            gbc_chckbxLanguages.anchor = 17;
            gbc_chckbxLanguages.insets = new Insets(0, 0, 5, 0);
            gbc_chckbxLanguages.gridx = 2;
            gbc_chckbxLanguages.gridy = 3;
            this.centerPanel.add((Component)this.getChckbxLanguages(), gbc_chckbxLanguages);
            GridBagConstraints gbc_chckbxStarttime = new GridBagConstraints();
            gbc_chckbxStarttime.anchor = 17;
            gbc_chckbxStarttime.insets = new Insets(0, 0, 5, 5);
            gbc_chckbxStarttime.gridx = 1;
            gbc_chckbxStarttime.gridy = 4;
            this.centerPanel.add((Component)this.getChckbxStarttime(), gbc_chckbxStarttime);
        }
        return this.centerPanel;
    }

    private JTextField getPortTextField() {
        if (this.portTextField == null) {
            this.portTextField = new JTextField();
            this.portTextField.setDocument(new IntegerDocument());
            this.portTextField.setText(Integer.toString(50443));
        }
        return this.portTextField;
    }

    private void updateGUI() {
        boolean serverRunning = this.jettyServer == null ? false : this.jettyServer.isRunning();
        this.getStartButton().setEnabled(!serverRunning);
        this.getStopButton().setEnabled(serverRunning);
        this.updateWebServerSettings(serverRunning);
        if (serverRunning) {
            this.webServerStatusLabel.setText("Web Server is running...");
        } else {
            this.webServerStatusLabel.setText("Web Server STOPPED");
        }
    }

    private void updateWebServerSettings(boolean serverRunning) {
        this.getPortTextField().setEditable(!serverRunning);
        this.getChckbxScoreboard().setEnabled(!serverRunning);
        this.getChckbxProblems().setEnabled(!serverRunning);
        this.getChckbxTeams().setEnabled(!serverRunning);
        this.getChckbxLanguages().setEnabled(!serverRunning);
        this.getChckbxStarttime().setEnabled(false);
        this.getChckbxStarttime().setVisible(false);
    }

    private JCheckBox getChckbxScoreboard() {
        if (this.chckbxScoreboard == null) {
            this.chckbxScoreboard = new JCheckBox("/scoreboard");
            this.chckbxScoreboard.setSelected(true);
            this.chckbxScoreboard.setHorizontalAlignment(2);
            this.chckbxScoreboard.setToolTipText("Enable getting contest scoreboard");
        }
        return this.chckbxScoreboard;
    }

    private JLabel getLblEnabledWebServices() {
        if (this.lblEnabledWebServices == null) {
            this.lblEnabledWebServices = new JLabel("Enable Web Services:");
        }
        return this.lblEnabledWebServices;
    }

    private JCheckBox getChckbxProblems() {
        if (this.chckbxProblems == null) {
            this.chckbxProblems = new JCheckBox("/problems");
            this.chckbxProblems.setSelected(true);
            this.chckbxProblems.setToolTipText("Enable getting contest problems");
            this.chckbxProblems.setHorizontalAlignment(2);
        }
        return this.chckbxProblems;
    }

    private JCheckBox getChckbxLanguages() {
        if (this.chckbxLanguages == null) {
            this.chckbxLanguages = new JCheckBox("/languages");
            this.chckbxLanguages.setSelected(true);
            this.chckbxLanguages.setHorizontalAlignment(2);
            this.chckbxLanguages.setToolTipText("Enable getting contest languages");
        }
        return this.chckbxLanguages;
    }

    private JCheckBox getChckbxStarttime() {
        if (this.chckbxStarttime == null) {
            this.chckbxStarttime = new JCheckBox("/starttime");
        }
        return this.chckbxStarttime;
    }

    private JCheckBox getChckbxTeams() {
        if (this.chckbxTeams == null) {
            this.chckbxTeams = new JCheckBox("/teams");
            this.chckbxTeams.setSelected(true);
            this.chckbxTeams.setToolTipText("Enable getting contest teams");
            this.chckbxTeams.setHorizontalAlignment(2);
        }
        return this.chckbxTeams;
    }
}

